import { compileGraphQL } from './test_helpers';

test.each([
  ['', 'Error: Unexpected end of input, expected valid field'],
  ['confid3ntial = true', 'Error: `confid3ntial` is not a recognized field.'],
  ['created', 'Error: Unexpected end of input, expected valid operator'],
  ['created >', 'Error: Unexpected end of input, expected valid value'],
  ['created = foo', 'Error: Expected valid value near `foo`'],
  ['milestone = "17.5\'', 'Error: Unterminated string `"17.5\'`'],
  ['milestone = "with escaped quotes\\"', 'Error: Unterminated string `"with escaped quotes\\"`'],
  ['confidential = true1bar and weight = 1', 'Error: Unexpected token near `1bar and weight = 1`'],
  ['author = null1 and weight = 1', 'Error: Unexpected token near `1 and weight = 1`'],
  ['confidential = true1', 'Error: Unexpected token near `1`'],
  ['author = null1', 'Error: Unexpected token near `1`'],
  ['label in (true1, false)', 'Error: Expected valid value near `(true1, false)`'],
  ['label in (true, false1)', 'Error: Expected valid value near `(true, false1)`'],
  ['author=currentUser() foo', 'Error: Unexpected token near `foo`'],
  ['label in (   true1 ,  false   )', 'Error: Expected valid value near `(   true1 ,  false   )`'],
  ['label in (   true,   false1 )', 'Error: Expected valid value near `(   true,   false1 )`'],
  [
    'created > 7x',
    'Error: Unexpected character `x`. Expected d (day), w (week), m (month), or y (year)',
  ],
])('%s', (query, expected) => {
  expect(compileGraphQL(query)).toBe(expected);
});

test.each([
  [
    "milestone = '17.5'",
    ['  issues(milestoneTitle: "17.5", before: $before, after: $after, first: $limit) {'],
  ],
  [
    'milestone = "17.5"',
    ['  issues(milestoneTitle: "17.5", before: $before, after: $after, first: $limit) {'],
  ],
  [
    'label in (~true, ~false)',
    [
      '  issues(',
      '    or: {labelNames: ["true", "false"]}',
      '    before: $before',
      '    after: $after',
      '    first: $limit',
      '  ) {',
    ],
  ],
  [
    'label in (   ~true    ,    ~false    )',
    [
      '  issues(',
      '    or: {labelNames: ["true", "false"]}',
      '    before: $before',
      '    after: $after',
      '    first: $limit',
      '  ) {',
    ],
  ],
  [
    '  \n    label in (~true, ~false)',
    [
      '  issues(',
      '    or: {labelNames: ["true", "false"]}',
      '    before: $before',
      '    after: $after',
      '    first: $limit',
      '  ) {',
    ],
  ],
  [
    'label in (~true, ~false)  \n    ',
    [
      '  issues(',
      '    or: {labelNames: ["true", "false"]}',
      '    before: $before',
      '    after: $after',
      '    first: $limit',
      '  ) {',
    ],
  ],
])('%s', (query, expected) => {
  expect(compileGraphQL(query).split('\n')).toEqual(expect.arrayContaining(expected));
});
