import { featureFlags } from '../../src/utils/feature_flags';
import { compileGraphQL } from './test_helpers';

test.each([
  [
    'milestone = "17.5"',
    ['    issues(milestoneTitle: "17.5", before: $before, after: $after, first: $limit) {'],
    ['    workItems(milestoneTitle: "17.5", before: $before, after: $after, first: $limit) {'],
  ],
  [
    'milestone in ("Backlog", "17.5")',
    [
      '    issues(',
      '      milestoneTitle: ["Backlog", "17.5"]',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
    [
      '    workItems(',
      '      milestoneTitle: ["Backlog", "17.5"]',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'milestone != ("Backlog", "17.5")',
    [
      '    issues(',
      '      not: {milestoneTitle: ["Backlog", "17.5"]}',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
    [
      '    workItems(',
      '      not: {milestoneTitle: ["Backlog", "17.5"]}',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'milestone = %Backlog',
    ['    issues(milestoneTitle: "Backlog", before: $before, after: $after, first: $limit) {'],
    [
      '    workItems(',
      '      milestoneTitle: "Backlog"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'milestone in (%Backlog, %"Awaiting further demand")',
    [
      '    issues(',
      '      milestoneTitle: ["Backlog", "Awaiting further demand"]',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
    [
      '    workItems(',
      '      milestoneTitle: ["Backlog", "Awaiting further demand"]',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
])('%s', (query, expectedIssues, expectedWorkItems) => {
  expect(compileGraphQL(`project = "gitlab-org/gitlab" and ${query}`).split('\n')).toEqual(
    expect.arrayContaining(expectedIssues),
  );

  featureFlags.glqlWorkItems = true;

  expect(compileGraphQL(`project = "gitlab-org/gitlab" and ${query}`).split('\n')).toEqual(
    expect.arrayContaining(expectedWorkItems),
  );
});

test.each`
  query                                | errorMessage
  ${'milestone = ("Backlog", "17.5")'} | ${'Error: `milestone` does not support the equals (`=`) operator for `("Backlog", "17.5")`. Supported operators: is one of (`in`), not equals (`!=`).'}
  ${'milestone = @username'}           | ${'Error: `milestone` cannot be compared with `@username`. Supported value types: `String`, `List`, `Nullable` (`null`, `none`, `any`), `Enum` (`upcoming`, `started`), `Milestone` (example: `%Backlog`).'}
  ${'milestone = %milestone#1'}        | ${'Error: Invalid milestone reference `%milestone#1`'}
`('$query', ({ query, errorMessage }) => {
  expect(compileGraphQL(`project = "gitlab-org/gitlab" and ${query}`)).toEqual(errorMessage);
});
