import { featureFlags } from '../../src/utils/feature_flags';
import { compileGraphQL } from './test_helpers';

test.each([
  [
    'id = 1',
    ['    issues(iids: "1", before: $before, after: $after, first: $limit) {'],
    ['    workItems(iids: "1", before: $before, after: $after, first: $limit) {'],
  ],
  [
    'id in (1, 2, 3)',
    ['    issues(iids: ["1", "2", "3"], before: $before, after: $after, first: $limit) {'],
    ['    workItems(iids: ["1", "2", "3"], before: $before, after: $after, first: $limit) {'],
  ],
])('%s', (query, expectedIssues, expectedWorkItems) => {
  expect(compileGraphQL(`project = "gitlab-org/gitlab" and ${query}`).split('\n')).toEqual(
    expect.arrayContaining(expectedIssues),
  );

  featureFlags.glqlWorkItems = true;

  expect(compileGraphQL(`project = "gitlab-org/gitlab" and ${query}`).split('\n')).toEqual(
    expect.arrayContaining(expectedWorkItems),
  );
});

test.each`
  query               | expectedError
  ${'id != 1'}        | ${'Error: `id` does not support the not equals (`!=`) operator. Supported operators: equals (`=`), is one of (`in`).'}
  ${'id = (1, 2, 3)'} | ${'Error: `id` does not support the equals (`=`) operator for `(1, 2, 3)`. Supported operators: is one of (`in`).'}
  ${'id = "1"'}       | ${'Error: `id` cannot be compared with `"1"`. Supported value types: `Number`, `List`.'}
  ${'id = (1, 2, 3)'} | ${'Error: `id` does not support the equals (`=`) operator for `(1, 2, 3)`. Supported operators: is one of (`in`).'}
`('%s', ({ query, expectedError }) => {
  expect(compileGraphQL(`project = "gitlab-org/gitlab" and ${query}`)).toBe(expectedError);
});
