import { compileGraphQL } from './test_helpers';
import { featureFlags } from '../../src/utils/feature_flags';

function testCase(query: string, expectedIssues: string[], expectedWorkItems: string[]) {
  featureFlags.glqlWorkItems = false;

  expect(compileGraphQL(`project = "gitlab-org/gitlab" and ${query}`).split('\n')).toEqual(
    expect.arrayContaining(expectedIssues),
  );

  featureFlags.glqlWorkItems = true;

  expect(compileGraphQL(`project = "gitlab-org/gitlab" and ${query}`).split('\n')).toEqual(
    expect.arrayContaining(expectedWorkItems),
  );
}

test('health equals at risk', () => {
  testCase(
    'health = "at risk"',
    [
      '    issues(',
      '      healthStatusFilter: atRisk',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
    [
      '    workItems(',
      '      healthStatusFilter: atRisk',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  );
});

test('health equals needs attention', () => {
  testCase(
    'health = "needs attention"',
    [
      '    issues(',
      '      healthStatusFilter: needsAttention',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
    [
      '    workItems(',
      '      healthStatusFilter: needsAttention',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  );
});

test('health equals on track', () => {
  testCase(
    'health = "on track"',
    [
      '    issues(',
      '      healthStatusFilter: onTrack',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
    [
      '    workItems(',
      '      healthStatusFilter: onTrack',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  );
});

test('health not equals', () => {
  testCase(
    'health != "at risk"',
    [
      '    issues(',
      '      not: {healthStatusFilter: atRisk}',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
    [
      '    workItems(',
      '      not: {healthStatusFilter: atRisk}',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  );
});

test('health status case insensitive', () => {
  testCase(
    'health = "NeEds attEntioN"',
    [
      '    issues(',
      '      healthStatusFilter: needsAttention',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
    [
      '    workItems(',
      '      healthStatusFilter: needsAttention',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  );
});
