import { compileGraphQL } from './test_helpers';

test.each([
  [
    'alias labels correct',
    "labels = ('foo', 'bar')",
    ['    issues(labelName: ["foo", "bar"], before: $before, after: $after, first: $limit) {'],
  ],
  [
    'alias labels incorrect',
    'labels = @root',
    [
      'Error: `labels` cannot be compared with `@root`. Supported value types: `String`, `List`, `Nullable` (`null`, `none`, `any`), `Label` (example: `~frontend`).',
    ],
  ],
  [
    'alias createdAt correct',
    "createdAt = '2023-01-01'",
    [
      '    issues(',
      '      createdAfter: "2023-01-01 00:00"',
      '      createdBefore: "2023-01-01 23:59"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'alias createdAt incorrect',
    'createdAt = @root',
    ['Error: `createdAt` cannot be compared with `@root`. Supported value types: `Date`.'],
  ],
  [
    'alias updatedAt correct',
    "updatedAt = '2023-01-01'",
    [
      '    issues(',
      '      updatedAfter: "2023-01-01 00:00"',
      '      updatedBefore: "2023-01-01 23:59"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'alias updatedAt incorrect',
    'updatedAt = @root',
    ['Error: `updatedAt` cannot be compared with `@root`. Supported value types: `Date`.'],
  ],
  [
    'alias assignees incorrect',
    "assignees = ('foo', 'bar')",
    [
      '    issues(',
      '      assigneeUsernames: ["foo", "bar"]',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'alias assignees incorrect',
    'assignees = ~foo',
    [
      'Error: `assignees` cannot be compared with `~foo`. Supported value types: `String`, `Username` (example: `@username`), `List`, `Number`, `Nullable` (`null`, `none`, `any`).',
    ],
  ],
  [
    'alias healthstatus correct',
    "healthStatus = 'on track'",
    [
      '    issues(',
      '      healthStatusFilter: onTrack',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'alias healthstatus incorrect',
    'healthStatus = @root',
    [
      'Error: `healthStatus` cannot be compared with `@root`. Supported value types: `StringEnum` (`"on track"`, `"needs attention"`, `"at risk"`), `Nullable` (`null`, `none`, `any`).',
    ],
  ],
  [
    'alias closedAt correct',
    "closedAt = '2023-01-01'",
    [
      '    issues(',
      '      closedAfter: "2023-01-01 00:00"',
      '      closedBefore: "2023-01-01 23:59"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'alias closedAt incorrect',
    'closedAt = @root',
    ['Error: `closedAt` cannot be compared with `@root`. Supported value types: `Date`.'],
  ],
  [
    'alias dueDate correct',
    "dueDate = '2023-01-01'",
    [
      '    issues(',
      '      dueAfter: "2023-01-01 00:00"',
      '      dueBefore: "2023-01-01 23:59"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'alias dueDate incorrect',
    'dueDate = @root',
    ['Error: `dueDate` cannot be compared with `@root`. Supported value types: `Date`.'],
  ],
  [
    'alias openedAt correct',
    "openedAt = '2023-01-01'",
    [
      '    issues(',
      '      createdAfter: "2023-01-01 00:00"',
      '      createdBefore: "2023-01-01 23:59"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'alias openedAt incorrect',
    'openedAt = @root',
    ['Error: `openedAt` cannot be compared with `@root`. Supported value types: `Date`.'],
  ],
  [
    'alias reviewers incorrect 1',
    "type = MergeRequest and reviewers = ('foo', 'bar')",
    [
      'Error: `reviewers` cannot be compared with `("foo", "bar")`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`).',
    ],
  ],
  [
    'alias reviewers incorrect 2',
    'type = MergeRequest and reviewers = ~foo',
    [
      'Error: `reviewers` cannot be compared with `~foo`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`).',
    ],
  ],
  [
    'alias reviewedBy correct',
    "type = MergeRequest and reviewedBy = 'foo'",
    [
      '    mergeRequests(',
      '      reviewerUsername: "foo"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'alias reviewedBy incorrect 1',
    "type = MergeRequest and reviewedBy = ('foo', 'bar')",
    [
      'Error: `reviewedBy` cannot be compared with `("foo", "bar")`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`).',
    ],
  ],
  [
    'alias reviewedBy incorrect 2',
    'type = MergeRequest and reviewedBy = ~foo',
    [
      'Error: `reviewedBy` cannot be compared with `~foo`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`).',
    ],
  ],
  [
    'alias mergedBy correct',
    "type = MergeRequest and mergedBy = 'foo'",
    ['    mergeRequests(mergedBy: "foo", before: $before, after: $after, first: $limit) {'],
  ],
  [
    'alias mergedBy incorrect',
    'type = MergeRequest and mergedBy = ~root',
    [
      'Error: `mergedBy` cannot be compared with `~root`. Supported value types: `String`, `Username` (example: `@username`).',
    ],
  ],
  [
    'alias approvers correct',
    "type = MergeRequest and approvers = ('foo', 'bar')",
    [
      '    mergeRequests(',
      '      approvedBy: ["foo", "bar"]',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'alias approvers incorrect',
    'type = MergeRequest and approvers = ~foo',
    [
      'Error: `approvers` cannot be compared with `~foo`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`), `List`.',
    ],
  ],
  [
    'alias approvedBy correct',
    "type = MergeRequest and approvedBy = ('foo', 'bar')",
    [
      '    mergeRequests(',
      '      approvedBy: ["foo", "bar"]',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'alias approvedBy incorrect',
    'type = MergeRequest and approvedBy = ~foo',
    [
      'Error: `approvedBy` cannot be compared with `~foo`. Supported value types: `String`, `Username` (example: `@username`), `Nullable` (`null`, `none`, `any`), `List`.',
    ],
  ],
  [
    'alias mergedAt correct',
    "type = MergeRequest and mergedAt = '2023-01-01'",
    [
      '    mergeRequests(',
      '      mergedAfter: "2023-01-01 00:00"',
      '      mergedBefore: "2023-01-01 23:59"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'alias mergedAt incorrect',
    'type = MergeRequest and mergedAt = @root',
    ['Error: `mergedAt` cannot be compared with `@root`. Supported value types: `Date`.'],
  ],
  [
    'alias deployedAt correct',
    "type = MergeRequest and deployedAt = '2023-01-01'",
    [
      '    mergeRequests(',
      '      deployedAfter: "2023-01-01 00:00"',
      '      deployedBefore: "2023-01-01 23:59"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ],
  ],
  [
    'alias deployedAt incorrect',
    'type = MergeRequest and deployedAt = @root',
    ['Error: `deployedAt` cannot be compared with `@root`. Supported value types: `Date`.'],
  ],
])('%s', (_, query, expected) => {
  expect(compileGraphQL(`project = "gitlab-org/gitlab" and ${query}`).split('\n')).toEqual(
    expect.arrayContaining(expected),
  );
});
