import { featureFlags } from '../../src/utils/feature_flags';
import {
  compileWithGroupContext,
  compileWithProjectContext,
  compileWithUserContext,
} from './test_helpers';

test('current user with username', () => {
  expect(
    compileWithUserContext(
      'foo',
      `project = "gitlab-org/gitlab" and assignee = currentUser()`,
    ).split('\n'),
  ).toEqual(
    expect.arrayContaining([
      '    issues(assigneeUsernames: "foo", before: $before, after: $after, first: $limit) {',
    ]),
  );

  featureFlags.glqlWorkItems = true;

  expect(
    compileWithUserContext(
      'foo',
      `project = "gitlab-org/gitlab" and assignee = currentUser()`,
    ).split('\n'),
  ).toEqual(
    expect.arrayContaining([
      '    workItems(',
      '      assigneeUsernames: "foo"',
      '      before: $before',
      '      after: $after',
      '      first: $limit',
      '    ) {',
    ]),
  );
});

test('default group', () => {
  expect(compileWithGroupContext('bar', 'weight=1').split('\n')).toEqual(
    expect.arrayContaining(['  group(fullPath: "bar") {']),
  );
});

test('group precedence', () => {
  expect(compileWithGroupContext('bar', 'group="foo"').split('\n')).toEqual(
    expect.arrayContaining(['  group(fullPath: "foo") {']),
  );
});

test('default project', () => {
  expect(compileWithProjectContext('bar', 'weight=1').split('\n')).toEqual(
    expect.arrayContaining(['  project(fullPath: "bar") {']),
  );
});

test('project precedence', () => {
  expect(compileWithProjectContext('bar', 'project="foo"').split('\n')).toEqual(
    expect.arrayContaining(['  project(fullPath: "foo") {']),
  );
});
