import { DisplayField } from './display_field';

export class TransformOutput {
  constructor(
    public data: unknown,
    public fields: DisplayField[],
    public success: boolean = true,
    public error?: string,
  ) {}

  static success(data: unknown, fields: DisplayField[]) {
    return new TransformOutput(data, fields);
  }

  static error(error: string) {
    return new TransformOutput(undefined, [], false, `Error: ${error}`);
  }
}
