import { Field } from './field';

export class Sort {
  constructor(
    public field: Field,
    public order: SortOrder,
  ) {}

  clone() {
    return new Sort(this.field.clone(), this.order);
  }

  static fromString(s: string) {
    const parts = s.split(/\s+/);
    if (parts.length >= 2) {
      let order = parts[1]!.toLowerCase();
      if (['asc', 'ascending'].includes(order)) {
        order = SortOrder.Ascending;
      } else if (['desc', 'descending'].includes(order)) {
        order = SortOrder.Descending;
      } else {
        order = order as SortOrder;
      }
      return new Sort(Field.fromString(parts[0]!), order as SortOrder);
    }

    return new Sort(Field.fromString(s), SortOrder.Ascending);
  }
}

export const enum SortOrder {
  Ascending = 'asc',
  Descending = 'desc',
}
