import { DimensionSegment } from './dimension_segment';
import { Query } from './query';

export class SegmentedQuery {
  constructor(
    public query: Query,
    public segments: DimensionSegment[],
  ) {}

  get key() {
    return 'glql_' + this.segments.map((s) => s.key).join('_');
  }

  static segmentsFromKey(key: string): DimensionSegment[] {
    return key
      .split('_')
      .map((k) => DimensionSegment.fromKey(k))
      .filter((s): s is DimensionSegment => Boolean(s));
  }
}
