export enum ReferenceTokenType {
  User = '@',
  Milestone = '%',
  Label = '~',
  Iteration = '*iteration:',
  Epic = '&',
  WorkItem = '#',
}

export class ReferenceType<T extends ReferenceTokenType = ReferenceTokenType> {
  static User = new ReferenceType(ReferenceTokenType.User);
  static Milestone = new ReferenceType(ReferenceTokenType.Milestone);
  static Label = new ReferenceType(ReferenceTokenType.Label);
  static Iteration = new ReferenceType(ReferenceTokenType.Iteration);
  static Epic = new ReferenceType(ReferenceTokenType.Epic);
  static WorkItem = new ReferenceType(ReferenceTokenType.WorkItem);

  constructor(public type: T) {}

  toString() {
    switch (this.type) {
      case ReferenceTokenType.User:
        return '`Username` (example: `@username`)';
      case ReferenceTokenType.Milestone:
        return '`Milestone` (example: `%Backlog`)';
      case ReferenceTokenType.Label:
        return '`Label` (example: `~frontend`)';
      case ReferenceTokenType.Iteration:
        return '`Iteration` (example: `*iteration:25263`';
      case ReferenceTokenType.Epic:
        return '`Epic` (example: `&123` or `group-path&123`)';
      case ReferenceTokenType.WorkItem:
        return '`WorkItem` (example: `#123` or `group/project-path#123`)';
    }
  }

  eq(other: ReferenceType) {
    return this.type === other.type;
  }
}
