export const enum OperatorType {
  In = 'in',
  Equal = '=',
  NotEqual = '!=',
  GreaterThan = '>',
  GreaterThanEquals = '>=',
  LessThan = '<',
  LessThanEquals = '<=',
}

export class Operator {
  type: OperatorType;

  static In = new Operator(OperatorType.In);
  static Equal = new Operator(OperatorType.Equal);
  static NotEqual = new Operator(OperatorType.NotEqual);
  static GreaterThan = new Operator(OperatorType.GreaterThan);
  static GreaterThanEquals = new Operator(OperatorType.GreaterThanEquals);
  static LessThan = new Operator(OperatorType.LessThan);
  static LessThanEquals = new Operator(OperatorType.LessThanEquals);

  constructor(type: OperatorType) {
    this.type = type;
  }

  clone() {
    return new Operator(this.type);
  }

  eq(other: Operator) {
    return this.type === other.type;
  }

  toString() {
    switch (this.type) {
      case OperatorType.In:
        return 'is one of (`in`)';
      case OperatorType.Equal:
        return 'equals (`=`)';
      case OperatorType.NotEqual:
        return 'not equals (`!=`)';
      case OperatorType.GreaterThan:
        return 'greater than (`>`)';
      case OperatorType.GreaterThanEquals:
        return 'greater than or equal to (`>=`)';
      case OperatorType.LessThan:
        return 'less than (`<`)';
      case OperatorType.LessThanEquals:
        return 'less than or equal to (`<=`)';
    }
  }
}
