import { DisplayField } from './display_field';
import { Field } from './field';
import { DimensionFunction } from './dimension_function';
import { Query } from './query';

export class Dimension {
  constructor(
    public fn: DimensionFunction,
    public field: DisplayField,
  ) {}

  static fn(fn: DimensionFunction) {
    return new Dimension(fn, new DisplayField.Static(new Field.Unknown('unknown')));
  }

  on(field: DisplayField) {
    this.field = field;
    return this;
  }

  clone() {
    return new Dimension(this.fn, this.field.clone());
  }

  segment(query: Query) {
    return this.fn.segment(this, query);
  }
}
