import { Source, SourceName } from './source';
import { Variable } from './variable';

export class Context {
  source: Source = new Source(SourceName.Issues);
  username?: string;
  project?: string;
  group?: string;
  variables: Variable[] = [];

  constructor(ctx?: Partial<Context>) {
    Object.assign(this, ctx ?? {});
  }

  clone() {
    return new Context({
      source: this.source.clone(),
      username: this.username,
      project: this.project,
      group: this.group,
      variables: this.variables.map((v) => v.clone()),
    });
  }

  withProject(project: string) {
    this.project = project;
    return this;
  }

  withGroup(group: string) {
    this.group = group;
    return this;
  }
}
