import { Dimension } from './dimension';
import { DisplayField } from './display_field';
import { Variable } from './variable';

type VariablesMap = Record<string, Omit<Variable, 'key' | 'clone'>>;

export class CompileOutput {
  constructor(
    public output: string,
    public success = true,
    public variables: VariablesMap = {},
    public fields: DisplayField[] = [],
    public groupBy?: Dimension[],
    public aggregate?: DisplayField[],
  ) {}

  static success(output: string) {
    return new CompileOutput(output);
  }

  static error(error: string) {
    return new CompileOutput(`Error: ${error}`, false);
  }

  withVariables(variables: Variable[]) {
    this.variables = variables.reduce((acc, variable) => {
      acc[variable.key] = {
        type: variable.type,
        value: variable.value,
      };
      return acc;
    }, this.variables);

    return this;
  }

  withFields(fields: DisplayField[]) {
    this.fields = fields;
    return this;
  }

  withAggregationContext(groupBy?: Dimension[], aggregate?: DisplayField[]) {
    this.groupBy = groupBy;
    this.aggregate = aggregate;
    return this;
  }
}
