import { Query } from '../types/query';
import {
  combineExpressions,
  expandExpression,
  transformExpression,
  transformTokensInValue,
} from './expression';
import { Expression } from '../types/expression';

export function transform(query: Query): void {
  query.expressions = combineExpressions(
    query.expressions
      .flatMap((expr) => expandExpression(expr, query.context.source))
      .map((expr) =>
        transformExpression(
          new Expression(expr.field, expr.operator, transformTokensInValue(expr.value)),
          query.context.source,
        ),
      ),
  );
}
