import { DisplayField } from '../types/display_field';
import { FieldName } from '../types/field';
import { wildcardMatch } from '../utils/common';

// eslint-disable-next-line @typescript-eslint/no-explicit-any
export function transformFields(data: any, fields: DisplayField[]): any {
  for (let displayField of fields) {
    const fieldKey = displayField.key;
    const fieldName = displayField.name;

    displayField = displayField.dealias();

    nodes: for (let i = 0; ; i++) {
      if (!data.nodes[i]) break;

      if (displayField instanceof DisplayField.Function) {
        const { name, args } = displayField;
        switch (name) {
          case 'labels':
            {
              // eslint-disable-next-line @typescript-eslint/no-explicit-any
              const filtered: any[] = [];
              // eslint-disable-next-line @typescript-eslint/no-explicit-any
              const remaining: any[] = [];

              for (let j = 0; ; j++) {
                const label = data.nodes[i].labels?.nodes?.[j];
                if (!label) break;

                const labelTitle = label.title;
                if (args.some((value) => wildcardMatch(labelTitle, value))) {
                  filtered.push(label);
                } else {
                  remaining.push(label);
                }
              }

              data.nodes[i][fieldKey] = { nodes: filtered };
              data.nodes[i].labels = { nodes: remaining };
            }
            break;

          default:
            break nodes;
        }
      } else {
        switch (fieldKey) {
          case FieldName.LastComment:
            data.nodes[i][fieldKey] = data.nodes[i].lastComment?.nodes?.[0]?.bodyHtml || null;
            break;

          case FieldName.MeanTimeToMerge:
            data.nodes[i][fieldKey] =
              data.nodes[i].count === 0 ? 0 : data.nodes[i].totalTimeToMerge / data.nodes[i].count;
            break;

          default:
            data.nodes[i][fieldKey] = data.nodes[i][fieldName];
        }
      }
    }
  }

  return data;
}
