import { FieldName } from '../types/field';
import { Query } from '../types/query';
import { Source, SourceName } from '../types/source';
import { Value } from '../types/value';
import { featureFlags } from '../utils/feature_flags';

export function removeExtractedFields(query: Query) {
  query.expressions = query.expressions.filter((expr) => {
    switch (expr.field.dealias().name) {
      case FieldName.Type:
        return query.context.source.name === SourceName.Issues;
      case FieldName.Group:
      case FieldName.Project:
        return false;
      default:
        return true;
    }
  });
}

export function extractContext(query: Query) {
  query.expressions.forEach((expr) => {
    const field = expr.field.dealias();
    if (field.name === FieldName.Type && expr.value instanceof Value.Token) {
      if (expr.value.value.toLowerCase() === 'epic')
        // force enable glql work items for epics (except for subqueries)
        // because the work items API is stable for epics with constraint
        // excludeProjects: true, which is passed in graphql_filters.ts
        featureFlags.glqlWorkItems ||= !query.isSubquery;

      query.context.source = Source.fromString(expr.value.value);
    }

    if (field.name === FieldName.Group && expr.value instanceof Value.Quoted) {
      query.context.group = expr.value.value;
      query.context.project = undefined;
    }

    if (field.name === FieldName.Project && expr.value instanceof Value.Quoted) {
      query.context.project = expr.value.value;
      query.context.group = undefined;
    }
  });
}
