import { all, alt } from 'parsimmon';
import { array, nonArrayValue } from './literals';
import { GlqlParseError, GlqlParseErrorType } from '../errors';

export const value = alt(
  nonArrayValue,
  array,
  all.map((input) => {
    throw new GlqlParseError(GlqlParseErrorType.MissingValue, input);
  }),
);
