import initWasm, { compile as compileWasm, transform as transformWasm } from '../../pkg/glql';
import { compile as compileTs, transform as transformTs } from './lib';
import wasmData from '../../pkg/glql_bg.wasm';
import packageJson from '../../package.json';
import { CompileContext } from './types/compile_context';
import { CompileOutput } from './types/compile_output';
import { TransformOutput } from './types/transform_output';
import { TransformContext } from './types/transform_context';
import { featureFlags } from './utils/feature_flags';

const init = async (): Promise<void> => {
  // @ts-expect-error - wasmData is a function that returns a buffer
  await initWasm({ module_or_path: wasmData() });
};

export const glql = {
  version: packageJson.version,
  async compile(query: string, context: CompileContext): Promise<CompileOutput> {
    featureFlags.glqlTypescript = context.featureFlags?.glqlTypescript ?? false;

    if (featureFlags.glqlTypescript) {
      return compileTs(query, context);
    } else {
      await init();
      return JSON.parse(compileWasm(query, JSON.stringify(context)));
    }
  },
  async transform(data: unknown, context: TransformContext): Promise<TransformOutput> {
    if (featureFlags.glqlTypescript) {
      return transformTs(data, context);
    } else {
      await init();
      return JSON.parse(transformWasm(JSON.stringify(data), JSON.stringify(context)));
    }
  },
};
