import { GlqlAnalyzeError } from '../errors';
import { Field } from '../types/field';
import { FieldType } from '../types/field_type';
import { Source } from '../types/source';
import { Value } from '../types/value';

export class ValueAnalyzer {
  constructor(
    public readonly value: Value,
    public readonly source: Source,
  ) {}

  analyze(field: Field) {
    const MAX_ARRAY_SIZE = 100;

    if (this.value instanceof Value.List && this.value.value.length > MAX_ARRAY_SIZE) {
      throw new GlqlAnalyzeError.ArrayTooLarge(field, MAX_ARRAY_SIZE);
    }
  }

  fieldType(field: Field) {
    const { analyzer } = this.source;
    const fieldType = analyzer.fieldType(field);
    const allFieldTypes = analyzer.allFieldTypes(field);

    if (this.value instanceof Value.List && fieldType.isListLike && this.value.value.length > 0) {
      return fieldType.find((f) => f instanceof FieldType.ListLike);
    }

    if (
      this.value instanceof Value.Token &&
      fieldType.isEnumLike &&
      fieldType.enumValues.includes(this.value.value.toLowerCase())
    ) {
      return fieldType.find(
        (f) => f instanceof FieldType.EnumLike || f instanceof FieldType.StringEnumLike,
      );
    }

    return allFieldTypes.reduce((acc, type) => {
      if (type.analyzer.analyze(this.value)) return type;
      return acc;
    });
  }
}
