import { FieldType } from '../../types/field_type';
import { Operator } from '../../types/operator';
import { RelationshipType } from '../../types/relationship_type';
import { featureFlags } from '../../utils/feature_flags';

export function typeFieldType() {
  const workItemTypes = [
    'Issue',
    'Incident',
    'TestCase',
    'Requirement',
    'Task',
    'Ticket',
    'Objective',
    'KeyResult',
  ];

  const otherTypes = ['MergeRequest'];

  if (featureFlags.glqlWorkItems) {
    workItemTypes.push('Epic');
  } else {
    otherTypes.unshift('Epic');
  }

  const enumTypes = [...workItemTypes, ...otherTypes];
  const listEnumTypes = workItemTypes;

  return new FieldType.EnumLike(enumTypes)
    .withOps(Operator.Equal)
    .or(
      new FieldType.ListLike(
        RelationshipType.HasOne,
        new FieldType.EnumLike(listEnumTypes).withOps(Operator.In),
      ),
    );
}
