import { GlqlAnalyzeError } from '../../errors';
import { Field } from '../../types/field';
import { FieldType } from '../../types/field_type';
import { Sort } from '../../types/sort';
import { Source } from '../../types/source';

export abstract class SourceAnalyzer {
  abstract source: Source;
  abstract validSortFields: Field[];
  abstract isFieldValid(field: Field): boolean;
  abstract fieldType(field: Field): FieldType;

  allFieldTypes(field: Field): FieldType[] {
    const fieldType = this.fieldType(field);
    if (fieldType instanceof FieldType.Multiple) {
      return fieldType.fieldTypes;
    }

    return [fieldType];
  }

  analyzeField(field: Field) {
    if (!this.isFieldValid(field))
      throw new GlqlAnalyzeError.UnrecognizedFieldForSource(field, this.source);
  }

  analyzeSortField(sort: Sort) {
    if (!this.validSortFields.some((field) => field.eq(sort.field.dealias()))) {
      throw new GlqlAnalyzeError.UnrecognizedSortFieldForSource(
        sort.field,
        this.source,
        this.validSortFields,
      );
    }
  }
}
