import { Source } from '../types/source';
import { Sort, SortOrder } from '../types/sort';
import { GlqlAnalyzeError } from '../errors';

export class SortAnalyzer {
  constructor(
    public readonly sort: Sort,
    public readonly source: Source,
  ) {}

  analyze() {
    this.source.analyzer.analyzeSortField(this.sort);
    this.analyzeOrder();
  }

  analyzeOrder() {
    if (![SortOrder.Ascending, SortOrder.Descending].includes(this.sort.order))
      throw new GlqlAnalyzeError.InvalidSortOrder(this.sort.order);
  }
}
