import { Expression } from '../types/expression';
import { Source } from '../types/source';
import { FieldAnalyzer } from './field';
import { ValueAnalyzer } from './value';

export class ExpressionAnalyzer {
  constructor(
    public readonly expression: Expression,
    public readonly source: Source,
  ) {}

  analyze() {
    new FieldAnalyzer(this.expression.field, this.source).analyze(
      this.expression.operator,
      this.expression.value,
    );

    new ValueAnalyzer(this.expression.value, this.source).analyze(this.expression.field);
  }
}
