module.exports = {
  preset: 'ts-jest',
  testEnvironment: 'node',
  transform: {
    '^.+\\.ts$': ['ts-jest', { tsconfig: 'tsconfig.json' }],
    '^.+\\.js$': [
      'babel-jest',
      {
        presets: [['@babel/preset-env', { targets: { node: 'current' } }]],
        plugins: ['babel-plugin-transform-import-meta'],
      },
    ],
  },
  testMatch: [
    '**/src/**/*.test.ts',
    '**/src/**/*.test.js',
    '**/tests/**/*.test.ts',
    '**/tests/**/*.test.js',
  ],
  moduleFileExtensions: ['ts', 'js', 'json'],
  moduleNameMapper: {
    '\\.wasm$': '<rootDir>/npm/tests/__mocks__/wasmBuffer.ts',
  },
  // Coverage configuration
  collectCoverage: false, // Will be enabled via CLI flag
  coverageDirectory: 'coverage-ts',
  coverageReporters: ['html', 'lcov', 'cobertura', 'text-summary'],
  collectCoverageFrom: [
    'npm/src/**/*.ts',
    '!npm/src/**/*.test.ts',
    '!npm/src/**/*.d.ts',
    '!npm/src/**/__mocks__/**',
    '!npm/src/**/__tests__/**',
  ],
  coveragePathIgnorePatterns: [
    '/node_modules/',
    '/pkg/',
    '/target/',
    '/coverage/',
    '/coverage-ts/',
    '\\.test\\.',
    '\\.d\\.ts$',
  ],
  coverageThreshold: {
    global: {
      branches: 0,
      functions: 0,
      lines: 0,
      statements: 0,
    },
  },
};
