# frozen_string_literal: true

require_relative "lib/gitlab_query_language/version"

Gem::Specification.new do |spec|
  spec.name = "gitlab_query_language"
  spec.version = Glql::VERSION
  spec.authors = ["Himanshu Kapoor", "Daniele Rossetti"]
  spec.email = ["hkapoor@gitlab.com", "drossetti@gitlab.com"]

  spec.summary = "GitLab Query Language compiler"
  spec.description = "A library to compile GitLab Query Language (GLQL) queries to GraphQL"
  spec.homepage = "https://gitlab.com/gitlab-org/glql/-/tree/main/glql_rb"
  spec.license = 'MIT'
  spec.required_ruby_version = ">= 3.2.0"
  spec.required_rubygems_version = ">= 3.3.11"

  spec.metadata["homepage_uri"] = spec.homepage
  spec.metadata["source_code_uri"] = spec.homepage
  spec.metadata["changelog_uri"] = "#{spec.homepage}/-/releases"

  spec.files = ["LICENSE", "README.md", "Cargo.lock"]
  spec.files += Dir.glob("lib/**/*.rb")
  spec.files += Dir.glob("lib/**/*.{so,bundle,dylib}")
  spec.files += Dir.glob("ext/**/*.{rs,toml,lock,rb}")

  spec.require_paths = ["lib"]
  spec.extensions = ["ext/gitlab_query_language/extconf.rb"]

  # Uncomment to register a new dependency of your gem
  # spec.add_dependency "example-gem", "~> 1.0"
  spec.add_dependency "rb_sys", "~> 0.9.91"

  # For more information and examples about making a new gem, check out our
  # guide at: https://bundler.io/guides/creating_gem.html
end
