#![no_main]

use libfuzzer_sys::fuzz_target;

use chrono::Utc;
use glql::compile_glql;
use glql::types::Context;

fuzz_target!(|data: &[u8]| {
    let mut context = Context {
        current_time: Utc::now(),
        current_user: None,
        preferred_fields: Some(preferred_fields()),
        preferred_project: None,
        preferred_group: None,
        preferred_limit: Some(100),
    };

    if let Ok(s) = std::str::from_utf8(data) {
        let _ = compile_glql(s, &mut context);
    }
});

fn preferred_fields() -> Vec<String> {
    vec![
        "id".to_string(),
        "iid".to_string(),
        "title".to_string(),
        "description".to_string(),
    ]
}
