import js from '@eslint/js';
import typescript from 'typescript-eslint';
import prettierConfig from 'eslint-config-prettier';
import { defineConfig } from 'eslint/config';

export default defineConfig(
  js.configs.recommended,
  typescript.configs.recommended,
  prettierConfig,
  {
    rules: {
      'no-console': 'error',
      '@typescript-eslint/no-namespace': 'off',
    },
  },
  {
    ignores: [
      'node_modules/',
      'npm/dist/',
      'target/',
      'coverage/',
      'coverage-ts/',
      'pkg/',
      '*.config.js',
      '*.config.mjs',
    ],
  },
);
