# frozen_string_literal: true

require 'spec_helper'
require_migration!

RSpec.describe QueueBackfillOccurrenceIdToVulnerabilityRepresentationInformation,
  migration: :gitlab_sec, feature_category: :vulnerability_management do
  let!(:batched_migration) { described_class::MIGRATION }

  it 'schedules a new batched migration' do
    reversible_migration do |migration|
      migration.before -> {
        expect(batched_migration).not_to have_scheduled_batched_migration
      }

      migration.after -> {
        expect(batched_migration).to have_scheduled_batched_migration(
          gitlab_schema: :gitlab_sec,
          table_name: :vulnerability_representation_information,
          column_name: :vulnerability_id
        )
      }
    end
  end
end
