---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: ブランチ保護、承認ルール、アクセス制御を使用して、リポジトリを保護します。
title: リポジトリを保護する
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

リポジトリ保護により、開発ワークフローを維持しながら、コードベースへの不正な変更を防ぐことができます。これらの制御は、次のような一般的な開発課題の解決に役立ちます:

- 本番環境または保護ブランチへの誤ったコミット。
- 履歴内の機密データの公開。
- コードレビュープロセスのバイパス。
- 重要なファイルへの不正な変更。
- コミットの作成者の未検証。
- mainブランチに不適合なコードが入力される。

さまざまな保護方法を組み合わせることで、組織の標準を検証するためのポイントが作成されます。

より上位のGitLabティアは、包括的なセキュリティスキャンを適用し、コンプライアンスを強化し、複数のプロジェクトやグループ全体の脆弱性を管理するための追加ツールにアクセスできます。これらの環境では、一部の保護方法が組織によってすでに適用されている場合があります。これらの高度なセキュリティツールの詳細については、[アプリケーションの保護](../../application_security/secure_your_application.md)を参照してください。

## 保護方法 {#protection-methods}

GitLabは、リポジトリを保護するために連携する複数の保護方法を提供します。各メソッドはさまざまなセキュリティニーズに対応し、包括的な保護のために組み合わせることができます。

| 保護方法                                                | 説明                                                                                    | 使用するケース                                                                                                       | インスタンス                                    | グループ                                      | プロジェクト |
|------------------------------------------------------------------|------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|---------------------------------------------|---------------------------------------------|----------|
| [保護ブランチ](branches/protected.md)                      | ブランチに対する権限を制御して、コードの安定性と品質を確保します。                         | プッシュとマージができるユーザーの制御、誤った削除の防止、レビューの実施、または強制プッシュ権限の規制を行います。 | {{< icon name="dash-circle" >}}非対応          | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="check-circle-filled" >}}対応 |
| [マージリクエストの承認](../merge_requests/approvals/_index.md) | 変更をマージする前に承認を必要とするレビュープロセス。                                   | コードレビューを要求したり、承認ルールを作成したり、承認設定を構成したりします。                                      | {{< icon name="dash-circle" >}}非対応          | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="check-circle-filled" >}}対応 |
| [プッシュルール](push_rules.md)                                      | コミット、ファイル、およびタグ付けがリポジトリに入る前に検証する受信前のGitフック。 | コミットの内容を評価し、ブランチ名のルールを適用し、タグの削除を防ぎ、署名されたコミットを要求します。              | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="check-circle-filled" >}}対応 | {{< icon name="check-circle-filled" >}}対応 |
| [GitLabコードオーナー](../codeowners/_index.md)                           | あなたのコードベース内の特定のファイルとディレクトリに関する専門知識を持っている人を定義します。                 | 特定のファイルへの変更に対する専門家の承認を要求するか、コードメンテナンスの責任者を特定します。       | {{< icon name="dash-circle" >}}非対応          | {{< icon name="dash-circle" >}}非対応          | {{< icon name="check-circle-filled" >}}対応 |
| [ステータスチェック](../merge_requests/status_checks.md)              | マージリクエストのステータスを検証する外部システムへのAPIコール。                              | サードパーティのワークフローツールと統合するか、外部の品質要件に対して検証します。                      | {{< icon name="dash-circle" >}}非対応          | {{< icon name="dash-circle" >}}非対応          | {{< icon name="check-circle-filled" >}}対応 |

## ブランチルール {#branch-rules}

複数の保護方法を管理するために、GitLabは、保護ブランチ、承認ルール、およびステータスチェックのための統一された[ブランチルール](branches/branch_rules.md)インターフェースを提供します。プロジェクト設定の**ブランチルール**ページを使用して、1つの場所からすべてのブランチ保護を構成し、ブランチ全体の保護ステータスを表示し、複雑な保護の組み合わせを管理します。

{{< alert type="note" >}}

グループ保護の場合、グループ設定で保護ブランチとプッシュルールを構成します。**ブランチルール**ページは、プロジェクトでのみ使用できます。グループのルールは、グループ内のすべてのプロジェクトに適用され、作成したプロジェクト固有のルールとともに機能します。

{{< /alert >}}

## 保護戦略を構成する {#configure-your-protection-strategy}

あなたのワークフローとセキュリティ要件に基づいて保護方法を選択してください。以下は戦略の例です。

### ベースライン保護 {#baseline-protection}

すべてのリポジトリにわたって一貫したセキュリティ標準を確立するには:

- 新しいプロジェクトを自動的に保護するために、グループのデフォルトのブランチ保護を構成します。
- プッシュとマージができるユーザーを制御するために、保護ブランチを設定します。
- ピアレビューを実施するために、マージリクエストの承認を要求します。

### 包括的な保護 {#comprehensive-protection}

多層防御で重要なプロジェクトを保護するには:

- プッシュとマージができるユーザーを制御するために、保護ブランチと承認ルールを設定します。
- 機密ロジックを含むファイルに対してコードオーナーの承認を要求します。
- 作成者のIDを検証するために、署名されたコミットを適用します。
- 自動テストに対して検証するためにステータスチェックを追加します。
- プッシュルールをグループに適用して、すべてのプロジェクトで標準を適用します。

### 対象を絞った保護 {#targeted-protection}

特定のセキュリティ要件に対処するには:

- ファイルがドメインの専門知識を必要とするレビューを必要とする場合は、コードオーナーの承認を要求します。
- コミット標準とコンテンツ制限を維持するために、プッシュルールを適用します。
- 外部検証が必要な場合にステータスチェックを追加します。
- ワークフロー固有の要件に合わせて承認ルールを構成します。

## 始める {#get-started}

前提要件: 

- プロジェクトのメンテナーロールまたはグループのオーナーロールが少なくとも必要です。
- どのブランチを保護する必要があるかを特定します。
- あなたのコンプライアンスとセキュリティ要件を決定します。

リポジトリ保護を構成および実装するには:

1. スコープを選択します:
   - グループルールの場合、グループの**設定** > **リポジトリ**に移動します。
   - プロジェクト固有のルールの場合、プロジェクトの**設定** > **リポジトリ** > **ブランチルール**に移動します。

1. ベースライン保護を設定します:
   - デフォルトのブランチと他の重要なブランチのために保護ブランチを作成します。
     - グループ設定: **設定** > **リポジトリ** > **保護ブランチ**。
     - プロジェクト設定: **設定** > **リポジトリ** > **ブランチルール**。
   - **設定** > **マージリクエスト** > **マージリクエストの承認**で、マージ権限と承認要件を設定します。

1. レビュー要件を追加します:
   - 特定のファイルの`CODEOWNERS`ファイルでコードオーナーを定義します。
   - **設定** > **マージリクエスト**で承認ルールを設定します。

1. セキュリティ制御を有効にします:
   - プッシュルールを構成します:
     - グループの場合: **設定** > **リポジトリ** > **プッシュルール**。
     - プロジェクトの場合: **設定** > **リポジトリ** > **プッシュルール**。
   - **設定** > **リポジトリ** > **プッシュルール** > **署名されていないコミットを拒否**で署名されたコミットを有効にします。

1. 設定をテストします:
   - テストマージリクエストを作成します。
   - 保護ルールが正しくトリガーされることを確認します。
   - 結果に基づいて設定を調整します。

## 関連トピック {#related-topics}

- [ブランチルール](branches/branch_rules.md)
- [プッシュルール](push_rules.md)
- [マージリクエスト](../merge_requests/_index.md)
- [GitLabコードオーナー](../codeowners/_index.md)
- [ロールと権限](../../permissions.md)
