# frozen_string_literal: true

require 'spec_helper'

RSpec.describe Gitlab::BackgroundMigration::BackfillOccurrenceIdToVulnerabilityStateTransitions, feature_category: :vulnerability_management do
  it_behaves_like 'backfills occurrence id from vulnerabilities' do
    let(:batch_table) { :vulnerability_state_transitions }
    let!(:record) do
      model.create!(
        created_at: now,
        updated_at: now,
        author_id: user.id,
        vulnerability_id: vulnerability.id,
        from_state: 1,
        to_state: 2
      )
    end
  end
end
