# frozen_string_literal: true

require 'spec_helper'

RSpec.describe Gitlab::BackgroundMigration::BackfillOccurrenceIdToVulnerabilityRepresentationInformation,
  feature_category: :vulnerability_management do
  it_behaves_like 'backfills occurrence id from vulnerabilities' do
    let(:batch_table) { :vulnerability_representation_information }
    let(:batch_column) { :vulnerability_id }
    let!(:record) do
      model.create!(
        created_at: now,
        updated_at: now,
        vulnerability_id: vulnerability.id,
        project_id: project.id
      )
    end
  end
end
