# frozen_string_literal: true

require 'spec_helper'

RSpec.describe Gitlab::BackgroundMigration::BackfillOccurrenceIdToVulnerabilityReads, feature_category: :vulnerability_management do
  it_behaves_like 'backfills occurrence id from vulnerabilities' do
    let(:batch_table) { :vulnerability_reads }
    let!(:record) do
      model.create!(
        vulnerability_id: vulnerability.id,
        project_id: project.id,
        scanner_id: scanner.id,
        uuid: SecureRandom.uuid,
        report_type: 1,
        severity: 1,
        state: 1
      )
    end
  end
end
