# frozen_string_literal: true

require 'spec_helper'

RSpec.describe Gitlab::BackgroundMigration::BackfillOccurrenceIdToVulnerabilityIssueLinks, feature_category: :vulnerability_management do
  let(:work_item_type) do
    # spec_helper seeds these using `TestEnv.seed_db`
    table(:work_item_types).where(base_type: 0).first
  end

  let(:issue) do
    table(:issues).create!(
      work_item_type_id: work_item_type.id,
      namespace_id: project.namespace_id
    )
  end

  it_behaves_like 'backfills occurrence id from vulnerabilities' do
    let(:batch_table) { :vulnerability_issue_links }
    let!(:record) do
      model.create!(
        created_at: now,
        updated_at: now,
        vulnerability_id: vulnerability.id,
        issue_id: issue.id,
        project_id: project.id
      )
    end
  end
end
