# frozen_string_literal: true

module QA
  RSpec.describe 'Plan', feature_category: :portfolio_management do
    describe 'Design Management' do
      let(:first_design) { Resource::Design.fabricate! }

      let(:second_design) do
        Resource::Design.fabricate! do |design|
          design.issue = first_design.issue
          design.filename = 'values.png'
        end
      end

      let(:third_design) do
        Resource::Design.fabricate_via_browser_ui! do |design|
          design.issue = second_design.issue
          design.filename = 'testfile.png'
        end
      end

      before do
        Flow::Login.sign_in
      end

      it(
        'user archives a design',
        testcase: 'https://gitlab.com/gitlab-org/gitlab/-/quality/test_cases/347713'
      ) do
        third_design.issue.visit!

        Page::Project::WorkItem::Show.perform do |issue|
          issue.select_design(third_design.filename)

          issue.archive_selected_designs

          expect(issue).not_to have_design(third_design.filename)
          expect(issue).to have_design(first_design.filename)
          expect(issue).to have_design(second_design.filename)
        end

        Page::Project::WorkItem::Show.perform do |issue|
          issue.select_design(second_design.filename)
          issue.select_design(first_design.filename)

          issue.archive_selected_designs

          expect(issue).not_to have_design(first_design.filename)
          expect(issue).not_to have_design(second_design.filename)
        end
      end
    end
  end
end
