---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token npm access token'
---

## Description

The response body contains content that matches the pattern of an npm access token was identified. Access tokens can either be classic or granular, both of which allow customization of permissions. Depending on the permissions, a malicious actor with access to this token can read packages and package information, or create new packages and publish them under the account that created them.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke an access token from the UI:

- Sign in to your npm account at <https://www.npmjs.com/login>
- In the upper-right corner, select your profile picture and then select "Access Tokens"
- Find the token that was identified and select "x" in the "Delete" column
- When prompted, select "OK" in the dialog

For more information, please see [npm's documentation on revoking access tokens](https://docs.npmjs.com/revoking-access-tokens).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.84 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
