---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Flutterwave test encrypted key'
---

## Description

The response body contains content that matches the pattern of a test Flutterwave encryption key was identified. This key is only used with the [direct charge endpoint](https://developer.flutterwave.com/docs/direct-card-charge). This key is used to encrypt payloads of card details prior to sending. More information can be found in [Flutterwave's encryption guide](https://developer.flutterwave.com/docs/encryption). A malicious actor with access to this key can potentially decrypt test transactions which can include credit card information.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate your key:

- Sign in and go to <https://app.flutterwave.com/dashboard/home>
- Select "Settings" on the left-hand menu
- Select "API Keys" under "Developers" on the left-hand menu
- Ensure "Test mode" is activated
- Select "Generate secret key" to rotate the public, secret, and encryption key

For more information, please see the [Flutterwave documentation on authentication](https://developer.flutterwave.com/docs/authentication).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.47 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
