---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: ファイルのロック
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

ファイルのロックにより、複数のユーザーが同じファイルを同時に編集できなくなり、マージコンフリクトの回避に役立ちます。ファイルのロックは、設計ファイル、ビデオ、その他のテキスト以外のコンテンツなど、マージできないバイナリファイルに特に役立ちます。

GitLabは、2種類のファイルのロックをサポートしています:

- [排他的ファイルのロック](../../topics/git/file_management.md#file-locks): Git LFSと[`.gitattributes`](repository/files/git_attributes.md)を使用してコマンドラインから適用されます。これらのロックは、任意のブランチ上のロックされたファイルの変更を防ぎます。
- [デフォルトブランチのファイルとディレクトリのロック](#default-branch-file-and-directory-locks): GitLab UIから適用されます。これらのロックは、デフォルトのブランチ上にあるファイルとディレクトリの変更のみを防ぎます。

## 権限 {#permissions}

ファイルロックを作成、表示、または管理するには、プロジェクトのデベロッパーロール以上が必要です。詳細については、[ロールと権限](../permissions.md)を参照してください。

## デフォルトブランチのファイルとディレクトリのロック {#default-branch-file-and-directory-locks}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

デフォルトブランチのロックは、プロジェクト設定で設定された[default branch](repository/branches/default.md)にのみ適用されます。これらのロックは、他のブランチでの共同作業者のワークフローをブロックすることなく、デフォルトブランチの安定性を維持するのに役立ちます。

ユーザーによってファイルまたはディレクトリがロックされている場合:

- ロックを作成したユーザーのみが、デフォルトブランチ上のファイルまたはディレクトリを変更できます。
- 他のユーザーの場合、ロックされたファイルまたはディレクトリは、デフォルトブランチ上で読み取り専用になります。
- デフォルトブランチ上のロックされたファイルまたはディレクトリへの直接の変更はブロックされます。
- ロックされたファイルまたはディレクトリを変更するマージリクエストは、デフォルトブランチにマージできません。

{{< alert type="note" >}}

デフォルト以外のブランチでは、すべてのユーザーがロックされたファイルとディレクトリを変更できます。これらのファイルとディレクトリには、**ロック**ステータスが表示されます。これにより、チームメンバーは、他のブランチでのワークフローを制限することなく、進行中の作業を認識できます。

ファイルのロックは、フォークの同期中にも回避されます。[フォークを更新](repository/forking_workflow.md#update-your-fork)をアップストリームプロジェクトからフォークした場合、フォーク内のロックされたファイルは、アップストリームプロジェクトからの変更で上書きできます。

{{< /alert >}}

## ファイルまたはディレクトリをロックする {#lock-a-file-or-directory}

前提要件: 

- プロジェクトのデベロッパーロール以上を持っている必要があります。

ファイルまたはディレクトリをロックするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. ロックするファイルまたはディレクトリに移動します。
1. 右上隅で**ロック**を選択します。
1. 確認ダイアログで、**OK**を選択します。

**ロック**が有効になっていない場合は、ファイルをロックするために必要な権限がありません。

ディレクトリをロックしたユーザーを表示するには（自分がロックしたのではない場合）、ボタンにカーソルを合わせるます。ロックされたファイルと同様の機能の復元については、[issue 376222](https://gitlab.com/gitlab-org/gitlab/-/issues/376222)で説明されています。

### アクションメニューからのファイル操作 {#file-operations-from-the-actions-menu}

{{< history >}}

- GitLab 17.10で`blob_overflow_menu`[フラグ](../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/519325)されました。デフォルトでは無効になっています。
- GitLab 18.1で[一般公開](https://gitlab.com/gitlab-org/gitlab/-/issues/522993)になりました。機能フラグ`blob_overflow_menu`は削除されました。

{{< /history >}}

ファイルをロックするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. ロックするファイルに移動します。
1. 右上隅のファイル名の横にある**アクション**（{{< icon name="ellipsis_v" >}}）> **ロック**を選択します。
1. 確認ダイアログで、**OK**を選択します。

ファイルをロックする権限がない場合、メニュー項目は無効になります。

## ロックされたファイルを表示 {#view-locked-files}

前提要件: 

- プロジェクトのデベロッパーロール以上を持っている必要があります。

ロックされたファイルを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **ロックされたファイル**を選択します。

**ロックされたファイル**ページには、Git LFS排他的ロックまたはGitLab UIのいずれかでロックされているすべてのファイルが表示されます。

## ファイルのロックを解除 {#remove-file-locks}

前提要件: 

- 次のいずれかの条件を満たす必要があります:
  - ロックを作成したユーザーである必要があります。
  - プロジェクトのメンテナー以上のロールを持っている必要があります。

ロックを解除するには:

{{< tabs >}}

{{< tab title="ファイルから" >}}

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. ロック解除するファイルに移動します。
1. **ロック解除**を選択します。
1. 確認ダイアログで、**ロック解除**を選択します。

{{< /tab >}}

{{< tab title="ロックされたファイルのページから" >}}

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **ロックされたファイル**を選択します。
1. ロックを解除するファイルの右側にある**ロック解除**を選択します。
1. 確認ダイアログで、**OK**を選択します。

{{< /tab >}}

{{< /tabs >}}

## 関連トピック {#related-topics}

- [Gitを使用したファイル管理](../../topics/git/file_management.md)
- [ファイルのロック](../../topics/git/file_management.md#file-locks)
