---
stage: AI-powered
group: Workflow Catalog
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: セキュリティアナリストエージェント
---

{{< details >}}

- プラン: Premium、Ultimate
- アドオン: GitLab Duo Core、Pro、またはEnterprise。
- 提供形態: GitLab.com
- ステータス: ベータ

{{< /details >}}

{{< history >}}

- GitLab 18.5で[導入](https://gitlab.com/groups/gitlab-org/-/epics/19659)されました。

{{< /history >}}

GitLabセキュリティアナリストエージェントは、GitLabの脆弱性管理およびセキュリティ分析ワークフローを支援する、専門的なAIアシスタントです。セキュリティに関する専門知識と、GitLabのセキュリティ機能、脆弱性レポート、セキュリティダッシュボード、コンプライアンスツールに関する深い知識を組み合わせることで、セキュリティ上の発見事項を効率的にトリアージし、評価し、修正するのに役立ちます。

GitLabセキュリティアナリストエージェントは、以下のような支援が必要な場合にご利用ください:

- 脆弱性トリアージ: さまざまなスキャンタイプにおけるセキュリティ上の発見事項を分析し、優先順位を付けます。
- リスク評価: 脆弱性の重大度、悪用可能性、ビジネスリスクを評価します。
- 誤検出の識別: 真の脅威と良性の発見事項を区別します。
- コンプライアンス管理: 規制要件と修正タイムラインを理解します。
- セキュリティレポート: セキュリティ対策状況と修正の進捗状況のサマリーを生成します。
- 修正計画: セキュリティ脆弱性に対処するための、実行可能な計画を作成します。
- セキュリティワークフローの自動化: 反復的なセキュリティ評価タスクを効率化します。

GitLabセキュリティアナリストエージェントは、脆弱性の状態、重大度レベル、セキュリティスキャナーの出力など、GitLab固有のセキュリティ実装を理解します。コンテキストに応じたセキュリティガイダンスを提供するために、EPSSスコア、CVEデータ、到達可能性分析を解釈できます。

## GitLabセキュリティアナリストエージェントへのアクセス {#access-the-gitlab-security-analyst-agent}

前提要件: 

- セキュリティスキャンが有効になっているGitLabプロジェクトで作業している必要があります。

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 右上隅で、**GitLab Duo Chatを開く**（{{< icon name="duo-chat" >}}）を選択します。画面の右側にドロワーが開きます。
1. **New chat**（{{< icon name="duo-chat-new" >}}）ドロップダウンリストから、**Security Analyst Agent**を選択します。
1. セキュリティ関連の質問またはリクエストを入力します。リクエストから最良の結果を得るには:

   - セキュリティ要件とリスク許容度に関するコンテキストを提供します。
   - どのタイプの脆弱性またはスキャン結果に焦点を当てているかを指定します。
   - 分析をリクエストするときは、関連するプロジェクトまたはコンポーネントの詳細を含めます。
   - セキュリティアナリストエージェントの推奨事項がセキュリティポリシーに合わない場合は、説明を求めてください。
   - 特定の発見事項について議論する場合は、特定の脆弱性IDまたはURLを使用します。

## プロンプトの例 {#example-prompts}

- 脆弱性分析:
  - 「プロジェクト内のすべての重大な脆弱性を表示してください。」
  - 「到達可能な0.7を超えるEPSSスコアを持つ脆弱性を一覧表示します。」
  - 「悪用可能性に基づいて、どのSASTの発見事項を優先すべきですか?」
  - 「（コンポーネント名）の脆弱性のセキュリティへの影響を分析します。」
  - 「今回のリリースと以前のリリースの間の脆弱性の傾向を比較します。」
- リスク評価:
  - 「これらのコンテナスキャンの発見事項のビジネスリスクは何ですか?」
  - 「この依存脆弱性が当社のユースケースに影響を与えるかどうかを評価してください。」
  - 「信頼境界を越える脆弱性の重大度を評価します。」
  - 「どの脆弱性が本番環境に最大のリスクをもたらしますか?」
- トリアージと管理:
  - 「到達不能なコードで誤検出としてマークされているすべての依存関係スキャンの脆弱性を無視します。」
  - 「既知のエクスプロイトを持つすべてのコンテナスキャンの脆弱性を確認します。」
  - 「信頼境界を越えるすべての脆弱性について、重大度を[高]に更新します。」
  - 「過去1週間に無視された脆弱性とその理由を表示します。」
  - 「再評価のために、脆弱性のステータスを[検出済み]に戻します。」
- イシュー管理:
  - 「確認されたすべての高重大度のSASTの脆弱性についてイシューを作成し、最近のコミッターに割り当てます」
  - 「修正を追跡するために、脆弱性（脆弱性ID）をイシュー（イシューID）にリンクします。」
  - 「重要なインフラストラクチャの脆弱性に対する修正タスクを生成します。」
  - 「すべての認証関連の脆弱性を追跡するためのセキュリティエピックを作成します。」
- レポートとコンプライアンス:
  - 「現在のセキュリティ対策状況のエグゼクティブサマリーを生成します。」
  - 「修正の進捗状況を示すコンプライアンスレポートを作成します。」
  - 「セキュリティレビュー委員会のためにセキュリティに関する発見事項を要約します。」
  - 「すべての高重大度の発見事項に対処するためのタイムラインを作成します。」
- 修正ガイダンス:
  - 「これらのSQLインジェクションの脆弱性に対する修正アプローチを提案します。」
  - 「このコンテナのベースイメージの脆弱性に対して推奨される修正は何ですか?」
  - 「次のスプリントのセキュリティパッチの優先順位付けを手伝ってください。」
  - 「これらの問題を防止するための安全なコード作成方法に関するガイダンスを提供します。」
