---
stage: Security Risk Management
group: Security Infrastructure
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 脆弱性アーカイブエクスポートAPI
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated
- ステータス: ベータ

{{< /details >}}

脆弱性アーカイブエクスポートへのAPIコールはすべて[認証される](rest/authentication.md)必要があります。

## プロジェクトのアーカイブされた脆弱性をエクスポートします {#export-archived-vulnerabilities-for-a-project}

プロジェクトの新しいエクスポートを作成します。

認証済みユーザーが[脆弱性を読み取り](../user/permissions.md#project-members-permissions)権限を持っていない場合、このリクエストは`403 Forbidden`ステータスコードを返します。

エクスポートは、作成後1か月間保持されます。

```plaintext
POST /security/projects/:id/vulnerability_archive_exports
```

| 属性       | 型              | 必須 | 説明                                                                                                               |
|-----------------|-------------------|----------|---------------------------------------------------------------------------------------------------------------------------|
| `id`            | 整数または文字列 | はい      | 認証済みユーザーがメンバーであるプロジェクトの[URLエンコードされたパス](rest/_index.md#namespaced-paths)、またはID。  |
| `start_date`    | 文字列            | はい      | `dd/mm/yyyy`形式の日付。この日付以降にアーカイブされた脆弱性は、エクスポートに含まれます。         |
| `end_date`      | 文字列            | はい      | `dd/mm/yyyy`形式の日付。この日付以前にアーカイブされた脆弱性は、エクスポートに含まれます。        |
| `export_format` | 文字列            | いいえ       | エクスポートの形式。デフォルトで唯一の有効な値は`csv`です。                                                          |

```shell
curl --request POST \
  --header "PRIVATE-TOKEN: <your_access_token>" \
  --url "https://gitlab.example.com/api/v4/security/projects/1/vulnerability_archive_exports"
```

レスポンス例:

```json
{
  "id": 2,
  "created_at": "2020-03-30T09:35:38.746Z",
  "project_id": 1,
  "format": "csv",
  "status": "created",
  "started_at": null,
  "finished_at": null,
  "_links": {
    "self": "https://gitlab.example.com/api/v4/security/vulnerability_archive_exports/2",
    "download": "https://gitlab.example.com/api/v4/security/vulnerability_archive_exports/2/download"
  }
}
```

## 単一の脆弱性アーカイブエクスポートを取得 {#get-single-vulnerability-archive-export}

既存のエクスポートの属性を取得します。このエンドポイントを使用して、エクスポートステータスが`finished`になるまでポーリングできます。クライアントは、次のポーリングを送信するまで待機する時間を決定するために、`Poll-Interval`応答ヘッダーを使用する必要があります。`Poll-Interval`は、ミリ秒単位の時間を表す数値です。

エクスポートには次のステータス値を設定できます:

| ステータス     | 説明                                                                         |
| ---------- | ----------------------------------------------------------------------------------- |
| `created`  | エクスポートはまだ実行されていません。                                             |
| `running`  | エクスポートを生成中です。                                                      |
| `finished` | エクスポートをダウンロードできるようになりました。                                           |
| `failed`   | エクスポートの生成中にエラーが発生し、完了できませんでした。       |
| `purged`   | エクスポートは削除待ちになっており、ファイルをダウンロードできなくなりました。 |

```plaintext
GET /security/vulnerability_archive_exports/:id
```

| 属性 | 型 | 必須 | 説明 |
| --------- | ---- | -------- | ----------- |
| `id` | 整数または文字列 | はい | 脆弱性アーカイブエクスポートのID |

```shell
curl --request GET \
  --header "PRIVATE-TOKEN: <your_access_token>" \
  --url "https://gitlab.example.com/api/v4/security/vulnerability_archive_exports/2"
```

脆弱性エクスポートが完了していない場合、応答は`202 Accepted`です。

レスポンス例:

```json
{
  "id": 2,
  "created_at": "2020-03-30T09:35:38.746Z",
  "project_id": 1,
  "format": "csv",
  "status": "running",
  "started_at": "2020-03-30T09:38:24Z",
  "finished_at": null,
  "_links": {
    "self": "https://gitlab.example.com/api/v4/security/vulnerability_archive_exports/2",
    "download": "https://gitlab.example.com/api/v4/security/vulnerability_archive_exports/2/download"
  }
}
```

## 脆弱性アーカイブエクスポートをダウンロード {#download-a-vulnerability-archive-export}

完了したエクスポートのエクスポートファイルをダウンロードします。このエンドポイントを呼び出す前に、エクスポートステータスが`finished`であることを[確認](#get-single-vulnerability-archive-export)してください。

```plaintext
GET /security/vulnerability_archive_exports/:id/download
```

| 属性 | 型 | 必須 | 説明 |
| --------- | ---- | -------- | ----------- |
| `id` | 整数または文字列 | はい | 脆弱性エクスポートのID |

```shell
curl --request GET \
  --header "PRIVATE-TOKEN: <your_access_token>" \
  --output export.csv \
  --url "https://gitlab.example.com/api/v4/security/vulnerability_archive_exports/2/download"
```

脆弱性エクスポートがまだ完了していないか、見つからなかった場合、応答は`404 Not Found`です。

レスポンス例:

```plaintext
Group Name,Project Name,Tool,Scanner Name,Status,Vulnerability,Details,Additional Info,Severity,CVE,CWE,Other Identifiers,Detected At,Location,Activity,Comments,Full Path,CVSS Vectors,Dismissal Reason
Gitlab.org,Defend,container_scanning,Trivy,resolved,CVE-2019-14697 in musl-utils-1.1.20-r4,"musl libc through 1.1.23 has an x87 floating-point stack adjustment imbalance, related to the math/i386/ directory. In some cases, use of this library could introduce out-of-bounds writes that are not present in an application's source code.",CVE-2019-14697 in musl-utils-1.1.20-r4,critical,CVE-2019-14697,,"",2022-10-07 13:34:41 UTC,"{""image""=>""python:3.4-alpine"", ""dependency""=>{""package""=>{""name""=>""musl-utils""}, ""version""=>""1.1.20-r4""}, ""operating_system""=>""alpine 3.9.2""}",true,"2022-10-07 13:41:08 UTC|root|resolved|changed vulnerability status to resolved",group/project/1,,,
Gitlab.org,Defend,container_scanning,Trivy,detected,CVE-2019-19242 in sqlite-libs-3.26.0-r3,"SQLite 3.30.1 mishandles pExpr->y.pTab, as demonstrated by the TK_COLUMN case in sqlite3ExprCodeTarget in expr.c.",CVE-2019-19242 in sqlite-libs-3.26.0-r3,medium,CVE-2019-19242,,"",2022-10-07 13:34:41 UTC,"{""image""=>""python:3.4-alpine"", ""dependency""=>{""package""=>{""name""=>""sqlite-libs""}, ""version""=>""3.26.0-r3""}, ""operating_system""=>""alpine 3.9.2""}",true,"",group/project/2,,,
Gitlab.org,Defend,container_scanning,Trivy,detected,CVE-2020-28928 in musl-1.1.20-r4,"In musl libc through 1.2.1, wcsnrtombs mishandles particular combinations of destination buffer size and source character limit, as demonstrated by an invalid write access (buffer overflow).",CVE-2020-28928 in musl-1.1.20-r4,medium,CVE-2020-28928,,"",2022-10-07 13:34:41 UTC,"{""image""=>""python:3.4-alpine"", ""dependency""=>{""package""=>{""name""=>""musl""}, ""version""=>""1.1.20-r4""}, ""operating_system""=>""alpine 3.9.2""}",true,"",group/project/3,,,
Gitlab.org,Defend,dependency_scanning,Gemnasium,detected,Improper Neutralization of Special Elements used in an OS Command ('OS Command Injection') in rack,Carefully crafted requests can cause shell escape sequences to be written to the terminal via Rack's Lint middleware and CommonLogger middleware. These escape sequences can be leveraged to possibly execute commands in the victim's terminal.,Improper Neutralization of Special Elements used in an OS Command ('OS Command Injection') in rack,unknown,Gemfile.lock:rack:gemnasium:60b5a27f-4e4d-4ab4-8ae7-74b4b212e177,,Gemnasium-60b5a27f-4e4d-4ab4-8ae7-74b4b212e177; GHSA-wq4h-7r42-5hrr,2022-10-14 13:16:00 UTC,"{""file""=>""Gemfile.lock"", ""dependency""=>{""package""=>{""name""=>""rack""}, ""version""=>""2.2.3""}}",false,group/project/4,,,
Gitlab.org,Defend,dependency_scanning,Gemnasium,detected,Denial of Service Vulnerability in Rack Multipart Parsing in rack,"Carefully crafted multipart POST requests can cause Rack's multipart parser to take much longer than expected, leading to a possible denial of service vulnerability. Impacted code will use Rack's multipart parser to parse multipart posts.",Denial of Service Vulnerability in Rack Multipart Parsing in rack,unknown,Gemfile.lock:rack:gemnasium:20daa17a-47b5-4f79-80c2-cd8f2db9805c,,Gemnasium-20daa17a-47b5-4f79-80c2-cd8f2db9805c; GHSA-hxqx-xwvh-44m2,2022-10-14 13:16:00 UTC,"{""file""=>""Gemfile.lock"", ""dependency""=>{""package""=>{""name""=>""rack""}, ""version""=>""2.2.3""}}",false,group/project/5,,,
Gitlab.org,Defend,sast,Brakeman,detected,Possible SQL injection,,Possible SQL injection,medium,e52f23a259cd489168b4313317ac94a3f13bffde57b9635171c1a44a9f329e9a,,"""Brakeman Warning Code 0""",2022-10-13 15:16:36 UTC,"{""file""=>""main.rb"", ""class""=>""User"", ""method""=>""index"", ""start_line""=>3}",false,"",group/project/6,,,
Gitlab.org,Defend,sast,Semgrep,dismissed,Improper Neutralization of Special Elements used in an SQL Command ('SQL Injection'),"SQL Injection is a critical vulnerability that can lead to data or system compromise...",,critical,,CWE-89,SCS0002,2023-12-28 10:48:34 UTC,"{""file""=>""WebGoat/App_Code/DB/SqliteDbProvider.cs"", ""start_line""=>274}",false,"2023-12-28 10:51:32 UTC|root|Dismissed|""changed vulnerability status to Dismissed: Not Applicable and the following comment: ""dismiss 5""",gitlab-org/defend/579,,Not applicable,
```
