---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Clojars deploy token'
---

## Description

The response body contains content that matches the pattern of a Clojars deploy token was detected. A deploy token is used in place of a password when deploying, and cannot be used to sign in. Tokens can be scoped to:

- Any artifact you have access to ("*")
- Any artifact in a group you have access to ("group-name/*")
- A particular artifact you have access to ("group-name/artifact-name") A malicious actor with access to this token can deploy malicious Clojure JARs by using this account.

Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke a deploy token:

1. Visit <https://clojars.org/tokens> after logging in.
1. Under "Existing Deploy Tokens" find the token that was detected
1. Select "Disable token".

   {{< alert type="note" >}}

   It's not possible to re-enable the token after disabling it.

   {{< /alert >}}

To create a new deploy token:

1. Visit <https://clojars.org/tokens> after logging in.
1. Fill out the Token name 1. Select the appropriate token scope
1. If the token is a single use, select the "Single use?" check box, otherwise leave blank
1. Set an expiration date (90 days is recommended)
1. Select "Create Token" For more information on tokens, please see [Clojars website](https://github.com/clojars/clojars-web/wiki/Deploy-Tokens).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.20 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
