---
stage: Application Security Testing
group: Secret Detection
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: シークレットプッシュ保護
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 16.7で、GitLab Dedicatedのお客様向けの[実験](../../../../policy/development_stages_support.md)として[導入](https://gitlab.com/groups/gitlab-org/-/epics/11439)されました。
- [変更](https://gitlab.com/groups/gitlab-org/-/epics/12729)してベータ版とし、GitLab 17.1のGitLab.comで利用できるようになりました。
- GitLab 17.2で、[フラグ](../../../../administration/feature_flags/_index.md) `pre_receive_secret_detection_beta_release`および`pre_receive_secret_detection_push_check`という名前の[GitLab Self-Managedで有効](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156907)。
- 機能フラグ`pre_receive_secret_detection_beta_release`は、GitLab 17.4で[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/472418)されました。
- GitLab 17.5で[一般提供](https://gitlab.com/groups/gitlab-org/-/epics/13107)になりました。
- 機能フラグ`pre_receive_secret_detection_push_check`は、GitLab 17.7で[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/472419)されました。

{{< /history >}}

キーやAPIトークンなどのシークレットがGitLabにプッシュされるのをブロックします。

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>概要については、プレイリスト[シークレットプッシュ保護の概要](https://www.youtube.com/playlist?list=PL05JrBw4t0KoADm-g2vxfyR0m6QLphTv-)をご覧ください。

パイプラインシークレット検出とシークレットプッシュ保護を併用して、セキュリティをさらに強化します。

## シークレットプッシュ保護ワークフロー {#secret-push-protection-workflow}

シークレットプッシュ保護は事前受信フックで行われます。GitLabに変更をプッシュすると、プッシュ保護は各ファイルまたはコミットにシークレットがないかチェックします。デフォルトでは、シークレットが検出された場合、プッシュはブロックされます。

<!-- To edit the diagram, use either Draw.io or the VS Code extension "Draw.io Integration" -->
![シークレット保護がどのようにプッシュをブロックできるかを示すフローチャート](img/spp_workflow_v17_9.drawio.svg)

プッシュがブロックされると、GitLabは次のメッセージを表示します:

- シークレットを含むコミットID。
- シークレットを含むファイル名と行。
- シークレットの種類。

たとえば、Gitコマンドラインを使用してプッシュがブロックされた場合に返されるメッセージの抜粋を次に示します。GitLab Web IDEを含む他のクライアントを使用する場合、メッセージの形式は異なりますが、内容は同じです。

```plain
remote: PUSH BLOCKED: Secrets detected in code changes
remote: Secret push protection found the following secrets in commit: 37e54de5e78c31d9e3c3821fd15f7069e3d375b6
remote:
remote: -- test.txt:2 GitLab Personal Access Token
remote:
remote: To push your changes you must remove the identified secrets.
```

シークレットプッシュ保護がコミットにシークレットを検出しない場合、メッセージは表示されません。

## 検出されたシークレット {#detected-secrets}

シークレットプッシュ保護は、特定のパターンについてファイルまたはコミットをスキャンします。各パターンは、特定の種類のシークレットと一致します。シークレットプッシュ保護によって検出されるシークレットを確認するには、[検出されたシークレット](../detected_secrets.md)をご覧ください。コミットをプッシュする際の遅延を最小限に抑えるし、誤検出の数を最小限に抑えるために、信頼性の高いパターンのみがシークレットプッシュ保護に選択されました。たとえば、カスタムプレフィックスを使用するパーソナルアクセストークンは、シークレットプッシュ保護では検出されません。選択したシークレットをシークレットプッシュ保護による検出から[除外](../exclusions.md)できます。

## はじめに {#getting-started}

GitLab DedicatedおよびGitLab Self-Managedのインスタンスでは、次のことを行う必要があります:

1. インスタンス全体でシークレットプッシュ保護を許可します。
1. シークレットプッシュ保護を有効にします。次のいずれかの方法があります:
   - 特定のプロジェクトでシークレットプッシュ保護を有効にします。
   - APIを使用して、グループ内のすべてのプロジェクトに対してシークレットプッシュ保護を有効にします。

### GitLabインスタンスでシークレットプッシュ保護の使用を許可する {#allow-the-use-of-secret-push-protection-in-your-gitlab-instance}

GitLab DedicatedおよびGitLab Self-Managedのインスタンスでは、プロジェクトで有効にする前に、シークレットプッシュ保護を許可する必要があります。

前提要件: 

- GitLabインスタンスの管理者である必要があります。

GitLabインスタンスでシークレットプッシュ保護の使用を許可するには:

1. 管理者としてGitLabインスタンスにサインインします。
1. 左側のサイドバーの下部で、**管理者**を選択します。
1. 左側のサイドバーの下部にある**設定** > **セキュリティとコンプライアンス**を選択します。
1. **シークレットの検出**で、**シークレットのプッシュ保護を許可する**を選択またはクリアします。

シークレットプッシュ保護がインスタンスで許可されます。この機能を使用するには、プロジェクトごとに有効にする必要があります。

### プロジェクトでシークレットプッシュ保護を有効にする {#enable-secret-push-protection-in-a-project}

前提要件: 

- プロジェクトのメンテナー以上のロールを持っている必要があります。
- GitLab DedicatedおよびGitLab Self-Managedでは、インスタンスでシークレットプッシュ保護を許可する必要があります。

プロジェクトでシークレットプッシュ保護を有効にするには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **セキュリティ設定**を選択します。
1. **シークレットのプッシュ保護**切替をオンにします。

API[を使用](../../../../api/group_security_settings.md#update-secret_push_protection_enabled-setting)して、グループ内のすべてのプロジェクトに対してシークレットプッシュ保護を有効にすることもできます。

## カバレッジ {#coverage}

{{< history >}}

- GitLab 17.11のdiffのみのスキャンに[変更](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/185882)されました。

{{< /history >}}

シークレットプッシュ保護は、次の場合にシークレットをブロックしません:

- コミットをプッシュしたときに、シークレットプッシュ保護をスキップするオプションを使用しました。
- シークレットがシークレットプッシュ保護から除外されています。
- シークレットは、除外として定義されたパスにあります。

シークレットプッシュ保護は、次の場合にコミット内のファイルをチェックしません:

- ファイルがバイナリファイルである。
- ファイルのサイズが1 MiBを超えている。
- ファイルの差分パッチが1 MiBを超えている（差分スキャンを使用する場合）。
- ファイルの名前が変更、削除、またはコンテンツの変更なしで移動された。
- ファイルの内容が、コードベース内の別のファイルの内容と同一である。
- ファイルが、リポジトリを作成した最初のプッシュに含まれている。

### 差分スキャン {#diff-scanning}

{{< history >}}

- GitLab 17.5で`spp_scan_diffs`[フラグ](../../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/469161)されました。デフォルトでは無効になっています。
- GitLab 17.6の[GitLab.comで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/480092)になりました。
- `secret_checks_for_web_requests`という名前の[機能フラグ](../../../../administration/feature_flags/_index.md)を使用して、GitLab 17.10でWeb IDEプッシュのサポートが[追加](https://gitlab.com/gitlab-org/gitlab/-/issues/491282)されました。デフォルトでは無効になっています。
- GitLab 17.11[で一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/525627)になりました。機能フラグ`spp_scan_diffs`は削除されました。
- `secret_checks_for_web_requests`機能フラグは、GitLab 17.11で[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/525629)されました。

{{< /history >}}

シークレットプッシュ保護は、HTTP(S) およびSSH経由でプッシュされたコミットの差分のみをスキャンします。シークレットがファイルに既に存在し、変更の一部でない場合、検出されません。

## 結果について理解する {#understanding-the-results}

シークレットプッシュ保護は、さまざまなカテゴリのシークレットを識別できます:

- APIキーとトークン: サービス固有の認証認証情報
- データベース接続文字列: 認証情報が埋め込まれたURL
- 秘密キー: 認証または暗号化用の暗号学的キー
- 汎用的な高エントロピー文字列: ランダムに生成されたシークレットと思われるパターン

プッシュがブロックされると、シークレットプッシュ保護は、検出されたシークレットの特定と対処に役立つ詳細情報を提供します:

- コミットID: シークレットを含む特定のコミット。Git履歴内の変更を追跡するのに役立ちます。
- ファイルパスと行番号: 迅速なナビゲーションのための検出されたパターンの正確な場所。
- シークレットの種類: 検出されたパターンの分類。例: `GitLab Personal Access Token`、`AWS Access Key`。

### 一般的な検出カテゴリ {#common-detection-categories}

すべての検出に迅速な対応が必要なわけではありません。結果を評価する際は、以下を検討してください:

- 真陽性: ローテーションして削除する必要がある正当なシークレット。例: 
  - 有効なAPIキーまたはトークン
  - 本番環境データベースの認証情報
  - プライベート暗号学的キー
  - 不正アクセスを許可する可能性のある認証情報

- 誤検出: 実際のシークレットではない、検出されたパターン。例: 
  - シークレットに似ているが、現実世界では価値のないテストデータ
  - 設定テンプレート内のプレースホルダー値
  - ドキュメント内の認証情報の例
  - シークレットパターンと一致するハッシュ値またはチェックサム

将来の評価を効率化するために、組織内の一般的な誤検出パターンを文書化します。

## 最適化 {#optimization}

シークレットプッシュ保護を広くデプロイする前に、設定を最適化して誤検出を減らし、特定の環境の精度を向上させます。

### 誤検出を減らす {#reduce-false-positives}

誤検出は、デベロッパーの生産性に大きな影響を与え、セキュリティフィードバックの低下につながる可能性があります。

誤検出を減らすには:

- 戦略的に除外を構成します:
  - テストディレクトリ、ドキュメント、サードパーティの依存関係について、パスベースの除外を作成します。
  - コードベースに固有の既知の誤検出パターンに対して、パターンベースの除外を使用します。
  - 除外ルールを文書化し、定期的にレビューします。
- プレースホルダー値とテスト認証情報の標準を作成します。
- 誤検出率を監視し、それに応じて除外を調整し続けます。

### パフォーマンスの最適化 {#optimize-performance}

大規模なリポジトリまたは頻繁なプッシュは、パフォーマンスに影響を与える可能性があります。

シークレットプッシュ保護のパフォーマンスを最適化するには:

- プッシュ時間を監視し、デプロイ前にベースラインメトリクスを確立します。
- 差分スキャンを使用して、各プッシュでスキャンされるコンテンツの量を減らします。
- 大規模なバイナリ資産を含むリポジトリのファイルサイズ制限を検討してください。
- シークレットが含まれている可能性が低いディレクトリの除外を実装します。

### 既存のワークフローとの統合 {#integration-with-existing-workflows}

シークレットプッシュ保護が既存の開発プラクティスを補完するようにします:

- パイプラインシークレット検出とシークレットプッシュ保護を構成して、多層防御を確保してください。
- シークレットプッシュ保護手順を含めるように、デベロッパーのドキュメントを更新します。
- セキュリティトレーニングと連携して、デベロッパーに安全なコード作成方法を教育し、流出したシークレットを最小限に抑えるします。

## ロールアウトする {#roll-out}

大規模にシークレットプッシュ保護を正常にデプロイするには、慎重な計画と段階的な実装が必要です:

1. アクティブな開発を行っている2つまたは3つの重要でないプロジェクトを選択して、機能をテストし、デベロッパーのワークフローへの影響を理解します。
1. 選択したテストプロジェクトのシークレットプッシュ保護をオンにし、デベロッパーのフィードバックを監視します。
1. ブロックされたプッシュを処理するためのプロセスを文書化し、開発チームに新しいワークフローについてトレーニングします。
1. パイロットフェーズ中に、検出されたシークレットの数、誤検出率、および開発者エクスペリエンスのフィードバックを追跡します。

より広範なデプロイの前に十分なデータを収集し、必要なワークフローの調整を特定するために、パイロットフェーズを2〜4週間実行する必要があります。

パイロットを完了したら、スケールされたロールアウトのために次のフェーズを検討してください:

1. アーリーアダプター（3〜6週目）
   - アクティブなプロジェクトの10〜20%で有効にし、セキュリティに敏感なリポジトリを優先します。
   - 強力なセキュリティ意識と賛同を得ているチームに焦点を当てます。
   - パフォーマンスへの影響と開発者エクスペリエンスを監視します。
   - 実際の使用状況に基づいてプロセスを改善します。
1. 広範なデプロイ（7〜12週目）
   - 残りのプロジェクト全体でバッチで段階的に有効にします。
   - 開発チームに継続的なサポートとトレーニングを提供します。
   - システムパフォーマンスを監視し、必要に応じてインフラストラクチャをスケールします。
   - 使用パターンに基づいて、除外ルールの最適化を継続します。
1. フルカバレッジ（13〜16週目）
   - 残りのすべてのプロジェクトでシークレットプッシュ保護を有効にします。
   - 継続的なメンテナンスとレビュープロセスを確立します。
   - 除外ルールと検出されたパターンの定期的な監査イベントを実装します。

## ブロックされたプッシュを解決する {#resolve-a-blocked-push}

シークレットプッシュ保護がプッシュをブロックすると、次のいずれかを実行できます:

- [シークレットを削除する](../remove_secrets_tutorial.md)。
- シークレットプッシュ保護をスキップします。

### シークレットプッシュ保護をスキップします {#skip-secret-push-protection}

場合によっては、シークレットプッシュ保護をスキップする必要があるかもしれません。たとえば、デベロッパーはテスト用にプレースホルダーシークレットをコミットする必要がある場合や、Git操作タイムアウトが原因でユーザーがシークレットプッシュ保護をスキップしたい場合があります。

シークレットプッシュ保護がスキップされると、監査イベントが記録されます。監査イベントの詳細には、次のものが含まれます:

- 使用されたスキップ方法。
- GitLabアカウント名。
- シークレットプッシュ保護がスキップされた日時。
- シークレットがプッシュされたプロジェクトの名前。
- ターゲットブランチ。（GitLab 17.4で導入）
- シークレットプッシュ保護をスキップしたコミット。（GitLab 17.9で導入）

パイプラインシークレット検出が有効になっている場合、すべてのコミットの内容は、リポジトリにプッシュされた後にスキャンされます。

プッシュ内のすべてのコミットに対してシークレットプッシュ保護をスキップするには、次のいずれかを実行します:

- Gitコマンドラインクライアントを使用している場合は、シークレットプッシュ保護をスキップするようにGitに指示します。
- 他のクライアントを使用している場合は、`[skip secret push protection]`をいずれかのコミットメッセージに追加します。

#### Gitコマンドラインクライアントの場合 {#for-the-git-cli-client}

コマンドラインからシークレットプッシュ保護をスキップするには:

- `secret_push_protection.skip_all`プッシュオプションを使用します。

  たとえば、シークレットが1つ含まれているために、複数のコミットがプッシュできないようにブロックされているとします。シークレットプッシュ保護をスキップするには、プッシュオプションをGitコマンドに追加します。

  ```shell
  git push -o secret_push_protection.skip_all
  ```

#### すべてのGitクライアントの場合 {#for-any-git-client}

シークレットプッシュ保護をスキップするには:

- 既存の行または新しい行のいずれかで、`[skip secret push protection]`をコミットメッセージの1つに追加し、コミットをプッシュします。

  たとえば、GitLab Web IDEを使用しており、シークレットが1つ含まれているために、複数のコミットがプッシュできないようにブロックされているとします。シークレットプッシュ保護をスキップするには、最新のコミットメッセージを編集して`[skip secret push protection]`を追加し、コミットをプッシュします。

## トラブルシューティング {#troubleshooting}

シークレットプッシュ保護を使用する際には、次の状況が発生する可能性があります。

### プッシュが予期せずブロックされた {#push-blocked-unexpectedly}

GitLab 17.11以前は、シークレットプッシュ保護は、変更されたすべてのファイルの内容をスキャンしていました。これにより、変更されたファイルにシークレットが含まれている場合、そのシークレットが差分の一部でなくても、プッシュが予期せずブロックされる可能性があります。

GitLab 17.11以前のバージョンでは、新規にコミットされた変更のみがスキャンされるように、`spp_scan_diffs`機能フラグを有効にしてください。シークレットを含むファイルに対するWeb IDEの変更をプッシュするには、`secret_checks_for_web_requests`機能フラグをさらに有効にする必要があります。

### ファイルがスキャンされませんでした {#file-was-not-scanned}

一部のファイルはスキャンから除外されています。詳細については、カバレッジを参照してください。
