import { IMPORT_HISTORY_TABLE_STATUS } from '~/vue_shared/components/import/constants';

const sixMonthsAgo = () => new Date(new Date().getTime() - 190 * 24 * 60 * 60 * 1000);
const fiveMinutesAgo = () => new Date(new Date().getTime() - 5 * 60 * 1000);

export const apiItems = [
  {
    id: 1,
    bulk_import_id: 0,
    entity_type: 'group',
    source_full_path: 'https://github.com/name/',
    created_at: fiveMinutesAgo(),
    failures: [],
    migrate_projects: true,
    migrate_memberships: true,
    has_failures: false,
    stats: {},
    action: {
      label: 'Import',
      buttonProps: {},
    },
  },
  {
    id: 2,
    bulk_import_id: 0,
    entity_type: 'group',
    source_full_path: 'https://github.com/somegroup',
    parent_id: null,
    namespace_id: 1,
    project_id: null,
    created_at: fiveMinutesAgo(),
    updated_at: fiveMinutesAgo(),
    failures: [],
    migrate_projects: true,
    migrate_memberships: true,
    has_failures: false,
    action: {
      label: 'Import',
      buttonProps: {},
    },
  },
  {
    id: 0,
    bulk_import_id: 0,
    status_name: IMPORT_HISTORY_TABLE_STATUS.inProgress,
    entity_type: 'group',
    source_full_path: 'https://github.com/coolworld/',
    full_path: 'my-group/coolworld',
    destination_name: 'coolworld',
    destination_slug: 'coolworld',
    destination_namespace: 'my-group',
    parent_id: 0,
    namespace_id: 2,
    project_id: 0,
    created_at: fiveMinutesAgo(),
    updated_at: fiveMinutesAgo(),
    migrate_projects: true,
    migrate_memberships: true,
    has_failures: true,
    nestedRow: {
      id: 214,
      bulk_import_id: 0,
      status_name: IMPORT_HISTORY_TABLE_STATUS.failed,
      entity_type: 'project',
      source_full_path: 'https://github.com/name/project.git',
      full_path: 'my-group/coolworld/project',
      destination_name: 'coolworld/project',
      destination_slug: 'coolworld/project',
      destination_namespace: 'my-group/coolworld',
      parent_id: 0,
      namespace_id: 2,
      project_id: 0,
      created_at: fiveMinutesAgo(),
      updated_at: fiveMinutesAgo(),
      failures: [
        {
          relation: 'design',
          exception_message: 'custom error message',
          exception_class: 'Exception',
          correlation_id_value: 'dfcf583058ed4508e4c7c617bd7f0edd',
          source_url: 'https://github.com/name/project.git',
          source_title: 'some title',
        },
      ],
      migrate_projects: true,
      migrate_memberships: true,
      has_failures: true,
      stats: {
        milestones: {
          source: 10,
          fetched: 10,
          imported: 10,
        },
        labels: {
          source: 10,
          fetched: 10,
          imported: 3,
        },
        design: {
          source: 10,
          fetched: 10,
          imported: 3,
        },
      },
    },
    action: {
      label: 'Re-import as a new group',
      buttonProps: {},
    },
  },
  {
    id: 4,
    bulk_import_id: 0,
    status_name: IMPORT_HISTORY_TABLE_STATUS.complete,
    entity_type: 'group',
    source_full_path: 'https://github.com/name',
    full_path: 'my-group/name',
    destination_name: 'name',
    destination_slug: 'name',
    destination_namespace: 'my-group',
    parent_id: 0,
    namespace_id: 2,
    project_id: 0,
    created_at: sixMonthsAgo(),
    updated_at: sixMonthsAgo(),
    migrate_projects: true,
    migrate_memberships: true,
    has_failures: true,
    nestedRow: {
      id: 214,
      bulk_import_id: 0,
      status_name: IMPORT_HISTORY_TABLE_STATUS.complete,
      entity_type: 'project',
      source_full_path: 'https://github.com/name/project.git',
      full_path: 'my-group/project',
      destination_name: 'project',
      destination_slug: 'project',
      destination_namespace: 'my-group',
      parent_id: 0,
      namespace_id: 2,
      project_id: 0,
      created_at: sixMonthsAgo(),
      updated_at: sixMonthsAgo(),
      migrate_projects: true,
      migrate_memberships: true,
      has_failures: true,
      stats: {
        labels: {
          source: 10,
          fetched: 10,
          imported: 10,
        },
        milestones: {
          source: 10,
          fetched: 10,
          imported: 10,
        },
      },
    },
    action: {
      label: 'Re-import as a new group',
      buttonProps: {},
    },
  },
];

export const basic = {
  items: apiItems,
};
