---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'チュートリアル: GitLabを使用してKanbanを促進する'
description: 進行中の作業、フロー、および配布。
---

<!-- vale gitlab_base.FutureTense = NO -->

このチュートリアルでは、カンバンワークフローでGitLabイシューボードを使用してタスクを管理する手順を説明します。グループ、プロジェクト、ボードをセットアップし、イシューを整理することで、透明性、コラボレーション、およびデリバリーを強化できます。

カンバンワークフローでGitLabイシューボードを使用してタスクを管理するには:

- [グループとプロジェクトを設定する](#set-up-groups-and-projects)
- [ラベルを作成する](#create-labels)
- [カンバンボードをセットアップする](#set-up-kanban-board)
- [フローと分布を視覚化する](#visualize-flow-and-distribution)

その他の情報については、このページの下部にある[高度なヒントとコツ](#advanced-tips-and-tricks)を参照してください。

## グループとプロジェクトを設定する {#set-up-groups-and-projects}

対応する手順に従って、[グループを作成](../../user/group/_index.md#create-a-group)し、[プロジェクト](../../user/project/_index.md)を作成します

チームが複数のリポジトリで作業している場合は、グループ内のリポジトリごとにプロジェクトを作成します。

イシューはそれぞれのプロジェクトに標準的に存在しますが、すべてのプロジェクトで表示レベルを維持できるように、カンバンボードはグループに存在します。単一のリポジトリで作業している場合は、この手順を省略できます。

## ラベルを作成する {#create-labels}

次に、カンバンライフサイクルの各ステップを表すラベルを作成しましょう:

- 単一のプロジェクトで作業している場合は、そのプロジェクトにラベルを作成します。
- 複数のプロジェクトで作業している場合は、グループにラベルを作成します。これにより、すべてのプロジェクトで単一のラベルセットを使用できます。

どちらのシナリオでも、ラベルを作成するプロセスは同じです。[作成](../../user/project/labels.md#create-a-label) [スコープ付きラベル](../../user/project/labels.md#scoped-labels)を**status::to do**（status::to do）、**status::doing**（status::doing）、**status::done**（status::done）に設定します。

## カンバンボードをセットアップする {#set-up-kanban-board}

ラベルを作成したら、次の手順としてカンバンボードを作成します:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループまたはプロジェクトを見つけます。
1. **Plan** > **イシューボード**を選択します。
1. イシューボードの左上隅にあるドロップダウンリストから、現在のボード名を選択します。
1. **新しいボードを作成する**を選択します。
1. 新しいボードの名前を入力し、**ボードを作成する**を選択します。
1. **\+ New list**（+ 新しいリスト）を選択して、新しいラベルリストを作成します。
1. リストのスコープを**ラベル**に設定し、値を**status::to do**（status::to do）に設定します。
1. 同じラベルリストの作成フローを繰り返して、さらに2つのラベルリスト（**status::doing**（status::doing）と**status::done**（status::done））を作成します。

おめでとうございます。これでカンバンボードができました。各リストに新しいイシューを作成したり、あるワークフローのステップから別のステップにイシューをドラッグアンドドロップしたり、チームメンバーにイシューを割り当てたりできるようになりました。

オプションで、ボードの各ラベルリストに対して[作業中の上限（WIP）](../../user/project/issue_board.md#work-in-progress-limits)を有効にできます。これを行うには、次の手順に従います:

1. ラベルリストの右上にある**リスト設定を編集**ギアアイコンを選択します。
1. **作業中の上限** > **編集**を選択します。
1. 対応するリストで許可されるイシューの最大数を入力し、**Enter**キーを押します。

これで、制限に達すると、リストの背景が自動的に赤色に変わります。「作業中の上限」カットラインもリストに表示され、制限を超えているすべてのイシューが線の下に視覚的に表示されます。

## フローと分布を視覚化する {#visualize-flow-and-distribution}

カンバンでは従来、累積フロー図を使用して負荷を視覚化し、ボトルネックの特定に役立てています。GitLabでは、[バリューストリーム分析（VSA）](../../user/group/value_stream_analytics/_index.md)でこれを実現できます。次に、カンバンワークフローに一致するカスタムVSAレポートを作成します。

### フローを視覚化する {#visualize-flow}

フローを視覚化するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループまたはプロジェクトを見つけます。
1. サイドナビゲーションで、**分析** > **バリューストリーム分析**を選択します。
1. ページ左上にある**バリューストリーム**ドロップダウンを選択し、**New Value Stream**（新しいバリューストリーム）を選択します。
1. VSAレポートに必要な名前を入力し、**Create from a template**（テンプレートから作成）オプションを選択します。
1. ステージ名に**To do**（To Do）を入力します。
1. 開始イベントで、**イシューラベルが追加されました**を選択し、**status::to do**（status::to do） ラベルを選択します。
1. 終了イベントで、**イシューラベルが削除されました**を選択し、**status::to do**（status::to do） ラベルを選択します。
1. 次に、**ステージを追加する**を選択します。
1. この同じプロセスを繰り返して、**status::in progress**（status::in progress）と**status::done**（status::done）のステージングを作成します。
1. 3つのステージングをすべて追加したら、**新しいバリューストリーム**を選択します。

カンバンボードと同じワークフローに一致するカスタムVSAレポートを使用すると、GitLabは各イシューが各ステージングで費やす時間を自動的に計算し、すべてのステージングでデータを集計します。その結果、リードタイムとサイクルタイムが得られます。各ステージングを詳しく調べて、個々のイシューの具体的なタイミングを確認できます。

### 分布を視覚化する {#visualize-distribution}

分布を視覚化するには:

1. 作成したVSAレポートで、**タイプ別のタスク**チャートまでスクロールダウンします。
1. 右上にある歯車アイコンのドロップダウンを選択し、イシューのタイプを表すラベルを検索して選択します。
1. **type::...**（type::...） スコープ付きラベルまたは同様のスコープ付きラベルを作成していない場合は、作業アイテムのタイプをワークフローに組み込むことを開始する良い機会です（たとえば、**feature**（feature）、**bug**（バグ）、**maintenance**（maintenance））。
1. **Show issues**（イシューを表示）を選択し、ドロップダウンリストの外側の任意の場所を選択して変更を適用します。
1. **タイプ別のタスク**チャートに、選択したラベルに一致するイシューの経時的な分布が表示されるようになりました。

## 高度なヒントとコツ {#advanced-tips-and-tricks}

- 指定された条件に基づいてイシューを自動的に更新するポリシーを作成するには、[`gitlab-triage`](https://gitlab.com/gitlab-org/ruby/gems/gitlab-triage)を設定します。たとえば、**status::done**（status::done） ラベルが適用されたときにイシューを自動的に閉じたり、イシューが作成されたときに**status::to do**（status::to do） ラベルを自動的に追加したりするポリシーを作成できます。オープンソース`gitlab-triage` gemは、GitLabパイプラインとシームレスに連携するように設計されています。
- さまざまなタイプのイシューの作成をより効率的かつ標準化するには、[説明テンプレート](../../user/project/description_templates.md)を作成します。
- グループまたはプロジェクト内の各チームメンバーの負荷を視覚化するには、**assignee lists**（担当者リスト）を使用して追加のイシューボードを作成します。
- Tシャツのサイズ設定イシューのスコープ付きラベルセットを作成します。たとえば、**size::small**（size::small）、**size::medium**（size::medium）、**size::large**（size::large）などです。
