import syntaxHighlight from '~/syntax_highlight';
import highlightCurrentUser from './highlight_current_user';
import { renderKroki } from './render_kroki';
import renderMath from './render_math';
import renderSandboxedMermaid from './render_sandboxed_mermaid';
import { renderGlql } from './render_glql';
import { renderJSONTable, renderJSONTableHTML } from './render_json_table';
import { addAriaLabels } from './accessibility';
import { renderImageLightbox } from './render_image_lightbox';

function initPopovers(elements) {
  if (!elements.length) return;
  import(/* webpackChunkName: 'IssuablePopoverBundle' */ '~/issuable/popover')
    .then(({ default: initIssuablePopovers }) => {
      initIssuablePopovers(elements);
    })
    .catch(() => {});
}

// Render GitLab flavored Markdown
export function renderGFM(element) {
  if (!element) {
    return;
  }

  const [
    highlightEls,
    krokiEls,
    mathEls,
    mermaidEls,
    tableEls,
    tableHTMLEls,
    glqlEls,
    userEls,
    popoverEls,
    taskListCheckboxEls,
    imageEls,
  ] = [
    '.js-syntax-highlight',
    '.js-render-kroki[hidden]',
    '.js-render-math',
    '.js-render-mermaid',
    '[data-canonical-lang="json"][data-lang-params~="table"]',
    'table[data-table-fields]',
    '[data-canonical-lang="glql"], .language-glql',
    '.gfm-project_member',
    '.gfm-issue, .gfm-work_item, .gfm-merge_request, .gfm-epic, .gfm-milestone',
    '.task-list-item-checkbox',
    // eslint-disable-next-line @gitlab/require-i18n-strings
    'a>img',
  ].map((selector) => Array.from(element.querySelectorAll(selector)));

  syntaxHighlight(highlightEls);
  renderKroki(krokiEls);
  renderMath(mathEls);
  renderSandboxedMermaid(mermaidEls);
  renderJSONTable(tableEls.map((e) => e.parentNode));
  renderJSONTableHTML(tableHTMLEls);
  highlightCurrentUser(userEls);
  initPopovers(popoverEls);
  addAriaLabels(taskListCheckboxEls);
  renderGlql(glqlEls);
  renderImageLightbox(imageEls, element);
}
