# frozen_string_literal: true

require 'spec_helper'

RSpec.describe GitHelper, feature_category: :source_code_management do
  describe '#short_sha' do
    let(:short_sha) { helper.short_sha('d4e043f6c20749a3ab3f4b8e23f2a8979f4b9100') }

    it { expect(short_sha).to eq('d4e043f6') }
  end

  describe '#strip_signature' do
    context 'strips PGP SIGNATURE' do
      let(:strip_signature) { helper.strip_signature(pgp_signature_tag) }

      it { expect(strip_signature).to eq("Version 1.69.0\n\n") }
    end

    context 'strips PGP MESSAGE' do
      let(:strip_signature) { helper.strip_signature(pgp_message_tag) }

      it { expect(strip_signature).to eq("Version 1.69.0\n\n") }
    end

    context 'strips SIGNED MESSAGE' do
      let(:strip_signature) { helper.strip_signature(x509_message_tag) }

      it { expect(strip_signature).to eq("this is Roger's signed tag\n\n") }
    end

    context 'strips SSH MESSAGE' do
      let(:strip_signature) { helper.strip_signature(ssh_message_tag) }

      it { expect(strip_signature).to eq("Version 1.70.0\n\n") }
    end
  end

  def pgp_signature_tag
    <<~SIGNATURE
    Version 1.69.0
    -----BEGIN PGP SIGNATURE-----

    iQEzBAABCAAdFiEEFMo1pwRq9j04Jovq68Q/GjfvLIoFAl2l64QACgkQ68Q/Gjfv
    LIqRDggAm0d1ceVRsfldlwC6guR2ly8aWoTtZZ19E12bsfXd4lJqcQv7JXTP0og0
    cwbV0l92iBJKGW6bFBipKDFmSgr5le5zFsXYOr9bJCQNOhFNMmtAgaHEIeVI16+c
    S3pA+qIe516d4wRs/hcbxDJKC68iIlDaLXObdzTTLGMgbCYBFTjYJldNUfTkdvbB
    oGEpFXuxV9EyfBtPLsz2vUea5GdZcRSVyJbcgm9ZU+ekdLZckroP5M0I5SQTbD3y
    VrbCY3ziYtau4zK4cV66ybRz1G7tR6dcoC4kGUbaZlKsVZ1Af80agx2d9k5MR1wS
    4OFe1H0zIfpPRFsyX2toaum3EX6QBA==
    =hefg
    -----END PGP SIGNATURE-----
    SIGNATURE
  end

  def pgp_message_tag
    <<~SIGNATURE
    Version 1.69.0
    -----BEGIN PGP MESSAGE-----

    iQEzBAABCAAdFiEEFMo1pwRq9j04Jovq68Q/GjfvLIoFAl2l64QACgkQ68Q/Gjfv
    LIqRDggAm0d1ceVRsfldlwC6guR2ly8aWoTtZZ19E12bsfXd4lJqcQv7JXTP0og0
    cwbV0l92iBJKGW6bFBipKDFmSgr5le5zFsXYOr9bJCQNOhFNMmtAgaHEIeVI16+c
    S3pA+qIe516d4wRs/hcbxDJKC68iIlDaLXObdzTTLGMgbCYBFTjYJldNUfTkdvbB
    oGEpFXuxV9EyfBtPLsz2vUea5GdZcRSVyJbcgm9ZU+ekdLZckroP5M0I5SQTbD3y
    VrbCY3ziYtau4zK4cV66ybRz1G7tR6dcoC4kGUbaZlKsVZ1Af80agx2d9k5MR1wS
    4OFe1H0zIfpPRFsyX2toaum3EX6QBA==
    =hefg
    -----END PGP MESSAGE-----
    SIGNATURE
  end

  def ssh_message_tag
    <<~SIGNATURE
    Version 1.70.0
    -----BEGIN SSH SIGNATURE-----

    iQEzBAABCAAdFiEEFMo1pwRq9j04Jovq68Q/GjfvLIoFAl2l64QACgkQ68Q/Gjfv
    LIqRDggAm0d1ceVRsfldlwC6guR2ly8aWoTtZZ19E12bsfXd4lJqcQv7JXTP0og0
    cwbV0l92iBJKGW6bFBipKDFmSgr5le5zFsXYOr9bJCQNOhFNMmtAgaHEIeVI16+c
    S3pA+qIe516d4wRs/hcbxDJKC68iIlDaLXObdzTTLGMgbCYBFTjYJldNUfTkdvbB
    oGEpFXuxV9EyfBtPLsz2vUea5GdZcRSVyJbcgm9ZU+ekdLZckroP5M0I5SQTbD3y
    VrbCY3ziYtau4zK4cV66ybRz1G7tR6dcoC4kGUbaZlKsVZ1Af80agx2d9k5MR1wS
    4OFe1H0zIfpPRFsyX2toaum3EX6QBA==
    =hefg
    -----END SSH SIGNATURE-----
    SIGNATURE
  end

  def x509_message_tag
    <<~SIGNATURE
    this is Roger's signed tag
    -----BEGIN SIGNED MESSAGE-----
    MIISfwYJKoZIhvcNAQcCoIIScDCCEmwCAQExDTALBglghkgBZQMEAgEwCwYJKoZI
    hvcNAQcBoIIP8zCCB3QwggVcoAMCAQICBBXXLOIwDQYJKoZIhvcNAQELBQAwgbYx
    CzAJBgNVBAYTAkRFMQ8wDQYDVQQIDAZCYXllcm4xETAPBgNVBAcMCE11ZW5jaGVu
    MRAwDgYDVQQKDAdTaWVtZW5zMREwDwYDVQQFEwhaWlpaWlpBNjEdMBsGA1UECwwU
    U2llbWVucyBUcnVzdCBDZW50ZXIxPzA9BgNVBAMMNlNpZW1lbnMgSXNzdWluZyBD
    QSBNZWRpdW0gU3RyZW5ndGggQXV0aGVudGljYXRpb24gMjAxNjAeFw0xNzAyMDMw
    NjU4MzNaFw0yMDAyMDMwNjU4MzNaMFsxETAPBgNVBAUTCFowMDBOV0RIMQ4wDAYD
    VQQqDAVSb2dlcjEOMAwGA1UEBAwFTWVpZXIxEDAOBgNVBAoMB1NpZW1lbnMxFDAS
    BgNVBAMMC01laWVyIFJvZ2VyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
    AQEAuBNea/68ZCnHYQjpm/k3ZBG0wBpEKSwG6lk9CEQlSxsqVLQHAoAKBIlJm1in
    YVLcK/Sq1yhYJ/qWcY/M53DhK2rpPuhtrWJUdOUy8EBWO20F4bd4Fw9pO7jt8bme
    u33TSrK772vKjuppzB6SeG13Cs08H+BIeD106G27h7ufsO00pvsxoSDL+uc4slnr
    pBL+2TAL7nSFnB9QHWmRIK27SPqJE+lESdb0pse11x1wjvqKy2Q7EjL9fpqJdHzX
    NLKHXd2r024TOORTa05DFTNR+kQEKKV96XfpYdtSBomXNQ44cisiPBJjFtYvfnFE
    wgrHa8fogn/b0C+A+HAoICN12wIDAQABo4IC4jCCAt4wHQYDVR0OBBYEFCF+gkUp
    XQ6xGc0kRWXuDFxzA14zMEMGA1UdEQQ8MDqgIwYKKwYBBAGCNxQCA6AVDBNyLm1l
    aWVyQHNpZW1lbnMuY29tgRNyLm1laWVyQHNpZW1lbnMuY29tMA4GA1UdDwEB/wQE
    AwIHgDAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwQwgcoGA1UdHwSBwjCB
    vzCBvKCBuaCBtoYmaHR0cDovL2NoLnNpZW1lbnMuY29tL3BraT9aWlpaWlpBNi5j
    cmyGQWxkYXA6Ly9jbC5zaWVtZW5zLm5ldC9DTj1aWlpaWlpBNixMPVBLST9jZXJ0
    aWZpY2F0ZVJldm9jYXRpb25MaXN0hklsZGFwOi8vY2wuc2llbWVucy5jb20vQ049
    WlpaWlpaQTYsbz1UcnVzdGNlbnRlcj9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0
    MEUGA1UdIAQ+MDwwOgYNKwYBBAGhaQcCAgMBAzApMCcGCCsGAQUFBwIBFhtodHRw
    Oi8vd3d3LnNpZW1lbnMuY29tL3BraS8wDAYDVR0TAQH/BAIwADAfBgNVHSMEGDAW
    gBT4FV1HDGx3e3LEAheRaKK292oJRDCCAQQGCCsGAQUFBwEBBIH3MIH0MDIGCCsG
    AQUFBzAChiZodHRwOi8vYWguc2llbWVucy5jb20vcGtpP1paWlpaWkE2LmNydDBB
    BggrBgEFBQcwAoY1bGRhcDovL2FsLnNpZW1lbnMubmV0L0NOPVpaWlpaWkE2LEw9
    UEtJP2NBQ2VydGlmaWNhdGUwSQYIKwYBBQUHMAKGPWxkYXA6Ly9hbC5zaWVtZW5z
    LmNvbS9DTj1aWlpaWlpBNixvPVRydXN0Y2VudGVyP2NBQ2VydGlmaWNhdGUwMAYI
    KwYBBQUHMAGGJGh0dHA6Ly9vY3NwLnBraS1zZXJ2aWNlcy5zaWVtZW5zLmNvbTAN
    BgkqhkiG9w0BAQsFAAOCAgEAXPVcX6vaEcszJqg5IemF9aFTlwTrX5ITNIpzcqG+
    kD5haOf2mZYLjl+MKtLC1XfmIsGCUZNb8bjP6QHQEI+2d6x/ZOqPq7Kd7PwVu6x6
    xZrkDjUyhUbUntT5+RBy++l3Wf6Cq6Kx+K8ambHBP/bu90/p2U8KfFAG3Kr2gI2q
    fZrnNMOxmJfZ3/sXxssgLkhbZ7hRa+MpLfQ6uFsSiat3vlawBBvTyHnoZ/7oRc8y
    qi6QzWcd76CPpMElYWibl+hJzKbBZUWvc71AzHR6i1QeZ6wubYz7vr+FF5Y7tnxB
    Vz6omPC9XAg0F+Dla6Zlz3Awj5imCzVXa+9SjtnsidmJdLcKzTAKyDewewoxYOOJ
    j3cJU7VSjJPl+2fVmDBaQwcNcUcu/TPAKApkegqO7tRF9IPhjhW8QkRnkqMetO3D
    OXmAFVIsEI0Hvb2cdb7B6jSpjGUuhaFm9TCKhQtCk2p8JCDTuaENLm1x34rrJKbT
    2vzyYN0CZtSkUdgD4yQxK9VWXGEzexRisWb4AnZjD2NAquLPpXmw8N0UwFD7MSpC
    dpaX7FktdvZmMXsnGiAdtLSbBgLVWOD1gmJFDjrhNbI8NOaOaNk4jrfGqNh5lhGU
    4DnBT2U6Cie1anLmFH/oZooAEXR2o3Nu+1mNDJChnJp0ovs08aa3zZvBdcloOvfU
    qdowggh3MIIGX6ADAgECAgQtyi/nMA0GCSqGSIb3DQEBCwUAMIGZMQswCQYDVQQG
    EwJERTEPMA0GA1UECAwGQmF5ZXJuMREwDwYDVQQHDAhNdWVuY2hlbjEQMA4GA1UE
    CgwHU2llbWVuczERMA8GA1UEBRMIWlpaWlpaQTExHTAbBgNVBAsMFFNpZW1lbnMg
    VHJ1c3QgQ2VudGVyMSIwIAYDVQQDDBlTaWVtZW5zIFJvb3QgQ0EgVjMuMCAyMDE2
    MB4XDTE2MDcyMDEzNDYxMFoXDTIyMDcyMDEzNDYxMFowgbYxCzAJBgNVBAYTAkRF
    MQ8wDQYDVQQIDAZCYXllcm4xETAPBgNVBAcMCE11ZW5jaGVuMRAwDgYDVQQKDAdT
    aWVtZW5zMREwDwYDVQQFEwhaWlpaWlpBNjEdMBsGA1UECwwUU2llbWVucyBUcnVz
    dCBDZW50ZXIxPzA9BgNVBAMMNlNpZW1lbnMgSXNzdWluZyBDQSBNZWRpdW0gU3Ry
    ZW5ndGggQXV0aGVudGljYXRpb24gMjAxNjCCAiIwDQYJKoZIhvcNAQEBBQADggIP
    ADCCAgoCggIBAL9UfK+JAZEqVMVvECdYF9IK4KSw34AqyNl3rYP5x03dtmKaNu+2
    0fQqNESA1NGzw3s6LmrKLh1cR991nB2cvKOXu7AvEGpSuxzIcOROd4NpvRx+Ej1p
    JIPeqf+ScmVK7lMSO8QL/QzjHOpGV3is9sG+ZIxOW9U1ESooy4Hal6ZNs4DNItsz
    piCKqm6G3et4r2WqCy2RRuSqvnmMza7Y8BZsLy0ZVo5teObQ37E/FxqSrbDI8nxn
    B7nVUve5ZjrqoIGSkEOtyo11003dVO1vmWB9A0WQGDqE/q3w178hGhKfxzRaqzyi
    SoADUYS2sD/CglGTUxVq6u0pGLLsCFjItcCWqW+T9fPYfJ2CEd5b3hvqdCn+pXjZ
    /gdX1XAcdUF5lRnGWifaYpT9n4s4adzX8q6oHSJxTppuAwLRKH6eXALbGQ1I9lGQ
    DSOipD/09xkEsPw6HOepmf2U3YxZK1VU2sHqugFJboeLcHMzp6E1n2ctlNG1GKE9
    FDHmdyFzDi0Nnxtf/GgVjnHF68hByEE1MYdJ4nJLuxoT9hyjYdRW9MpeNNxxZnmz
    W3zh7QxIqP0ZfIz6XVhzrI9uZiqwwojDiM5tEOUkQ7XyW6grNXe75yt6mTj89LlB
    H5fOW2RNmCy/jzBXDjgyskgK7kuCvUYTuRv8ITXbBY5axFA+CpxZqokpAgMBAAGj
    ggKmMIICojCCAQUGCCsGAQUFBwEBBIH4MIH1MEEGCCsGAQUFBzAChjVsZGFwOi8v
    YWwuc2llbWVucy5uZXQvQ049WlpaWlpaQTEsTD1QS0k/Y0FDZXJ0aWZpY2F0ZTAy
    BggrBgEFBQcwAoYmaHR0cDovL2FoLnNpZW1lbnMuY29tL3BraT9aWlpaWlpBMS5j
    cnQwSgYIKwYBBQUHMAKGPmxkYXA6Ly9hbC5zaWVtZW5zLmNvbS91aWQ9WlpaWlpa
    QTEsbz1UcnVzdGNlbnRlcj9jQUNlcnRpZmljYXRlMDAGCCsGAQUFBzABhiRodHRw
    Oi8vb2NzcC5wa2ktc2VydmljZXMuc2llbWVucy5jb20wHwYDVR0jBBgwFoAUcG2g
    UOyp0CxnnRkV/v0EczXD4tQwEgYDVR0TAQH/BAgwBgEB/wIBADBABgNVHSAEOTA3
    MDUGCCsGAQQBoWkHMCkwJwYIKwYBBQUHAgEWG2h0dHA6Ly93d3cuc2llbWVucy5j
    b20vcGtpLzCBxwYDVR0fBIG/MIG8MIG5oIG2oIGzhj9sZGFwOi8vY2wuc2llbWVu
    cy5uZXQvQ049WlpaWlpaQTEsTD1QS0k/YXV0aG9yaXR5UmV2b2NhdGlvbkxpc3SG
    Jmh0dHA6Ly9jaC5zaWVtZW5zLmNvbS9wa2k/WlpaWlpaQTEuY3JshkhsZGFwOi8v
    Y2wuc2llbWVucy5jb20vdWlkPVpaWlpaWkExLG89VHJ1c3RjZW50ZXI/YXV0aG9y
    aXR5UmV2b2NhdGlvbkxpc3QwJwYDVR0lBCAwHgYIKwYBBQUHAwIGCCsGAQUFBwME
    BggrBgEFBQcDCTAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFPgVXUcMbHd7csQC
    F5Foorb3aglEMA0GCSqGSIb3DQEBCwUAA4ICAQBw+sqMp3SS7DVKcILEmXbdRAg3
    lLO1r457KY+YgCT9uX4VG5EdRKcGfWXK6VHGCi4Dos5eXFV34Mq/p8nu1sqMuoGP
    YjHn604eWDprhGy6GrTYdxzcE/GGHkpkuE3Ir/45UcmZlOU41SJ9SNjuIVrSHMOf
    ccSY42BCspR/Q1Z/ykmIqQecdT3/Kkx02GzzSN2+HlW6cEO4GBW5RMqsvd2n0h2d
    fe2zcqOgkLtx7u2JCR/U77zfyxG3qXtcymoz0wgSHcsKIl+GUjITLkHfS9Op8V7C
    Gr/dX437sIg5pVHmEAWadjkIzqdHux+EF94Z6kaHywohc1xG0KvPYPX7iSNjkvhz
    4NY53DHmxl4YEMLffZnaS/dqyhe1GTpcpyN8WiR4KuPfxrkVDOsuzWFtMSvNdlOV
    gdI0MXcLMP+EOeANZWX6lGgJ3vWyemo58nzgshKd24MY3w3i6masUkxJH2KvI7UH
    /1Db3SC8oOUjInvSRej6M3ZhYWgugm6gbpUgFoDw/o9Cg6Qm71hY0JtcaPC13rzm
    N8a2Br0+Fa5e2VhwLmAxyfe1JKzqPwuHT0S5u05SQghL5VdzqfA8FCL/j4XC9yI6
    csZTAQi73xFQYVjZt3+aoSz84lOlTmVo/jgvGMY/JzH9I4mETGgAJRNj34Z/0meh
    M+pKWCojNH/dgyJSwDGCAlIwggJOAgEBMIG/MIG2MQswCQYDVQQGEwJERTEPMA0G
    A1UECAwGQmF5ZXJuMREwDwYDVQQHDAhNdWVuY2hlbjEQMA4GA1UECgwHU2llbWVu
    czERMA8GA1UEBRMIWlpaWlpaQTYxHTAbBgNVBAsMFFNpZW1lbnMgVHJ1c3QgQ2Vu
    dGVyMT8wPQYDVQQDDDZTaWVtZW5zIElzc3VpbmcgQ0EgTWVkaXVtIFN0cmVuZ3Ro
    IEF1dGhlbnRpY2F0aW9uIDIwMTYCBBXXLOIwCwYJYIZIAWUDBAIBoGkwHAYJKoZI
    hvcNAQkFMQ8XDTE5MTExNDE3MzYzNFowLwYJKoZIhvcNAQkEMSIEIJO0Q0yM+f6h
    pNqE7YCAEPwe751CamgWYqKBIUMjTViqMBgGCSqGSIb3DQEJAzELBgkqhkiG9w0B
    BwEwCwYJKoZIhvcNAQEBBIIBACZqs0NEuP1O/90avijVtTGicqMHp6vBBcmPJK7O
    WOsL1DIDfAww+fw0r5cMbnmJA+iTfY5iZU/nqMK9kiGx055eoqU9KJaWFzY3KFO/
    aOeXBCxv7CTDIVKoQtA0RCH6cGOgD6dnH2Lez3aDmziEd7gMqkBRo7lh1O6o5FQy
    xyZl3p3/MYrFTeZDnr0YeBWWzPrECaQkI1M7K1hdTqmURU1wE6tSANYyT7/BtN+O
    XVB/7uD6aTTo+eHyeJxcZGja0IsMXmwlsFqmlxxciYhQhQdPaXRcutdx0fMEF5Zq
    wxhu3ScPA3X7e2ENEKJNl5W1OT9YXvc3K9Hwvtj8USx3CJI=
    -----END SIGNED MESSAGE-----
    SIGNATURE
  end
end
