---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Contentful preview API token'
---

## Description

The response body contains content that matches the pattern of a Contentful preview API token was identified. A preview API token maintains the same behavior and parameters as the Content Delivery API (CDA), but delivers the latest drafts for entries and assets. The Content Preview API is used to display the latest version of an entry. A malicious actor with access to this token can view published and unpublished entries. For more information, please see [the Preview API documentation](https://www.contentful.com/developers/docs/references/content-preview-api/).
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke the preview API token:

- Sign in and visit <https://app.contentful.com/>
- Select the gear icon in the top right corner, and then select "API Keys"
- Find the API key that was detected, and select the name in the table of API keys
- Select "Delete" in the top right corner
- When prompted, select "Delete" Note this also deletes the delivery API token.

Generating a new set of API keys is required.

For more information, please see the developer [documentation on authentication](https://www.contentful.com/developers/docs/references/authentication/#the-content-delivery-and-preview-api).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.133 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
