---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Typeform personal access token'
---

## Description

The response body contains content that matches the pattern of a Typeform personal access token was identified. Personal access tokens are for accessing the Typeform API. depending on the assigned scope and permissions, a malicious actor with access to this token can read, update, or delete form data.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). To regenerate the Typeform API token: - Sign in to your Typeform account and go to <https://admin.typeform.com/> - In the top right corner, select your profile picture and select "Your settings" under "Account" - In the left-hand menu, select "Personal tokens" - In the "token name" table, find the identified token, select the ellipsis, and select "Regenerate token" For more information, please see [Typeform's documentation on personal access tokens](https://www.typeform.com/developers/get-started/personal-access-token/).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.124 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
