---
stage: Tenant Scale
group: Organizations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: プロジェクトを管理する
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLabでのほとんどの作業は、[プロジェクト](_index.md)内で行われます。ファイルとコードはプロジェクトに保存され、ほとんどの機能はプロジェクトのスコープ内にあります。

## プロジェクトの概要

{{< history >}}

- プロジェクトの作成日は、GitLab 16.10で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/19452)されました。

{{< /history >}}

プロジェクトを選択すると、**プロジェクトの概要**ページにプロジェクトの次の内容が表示されます。

- リポジトリ内のファイル
- プロジェクト情報（説明）
- トピック
- バッジ
- プロジェクト内のお気に入り、フォーク、コミット、ブランチ、タグ、リリース、環境の数
- プロジェクトのストレージサイズ
- オプションのファイルと設定
- `README`またはインデックスファイル
  - Wikiページ
  - ライセンス
  - 変更履歴
  - コントリビュートのガイドライン
  - Kubernetesクラスター
  - CI/CDの設定
  - インテグレーション
  - GitLab Pages
- 作成日

パブリックプロジェクト、および[プロジェクトのコードを表示する権限](../permissions.md#project-members-permissions)を持つ内部プロジェクトとプライベートプロジェクトのメンバーの場合、プロジェクトの概要ページには以下が表示されます。

- [`README`またはインデックスファイル](repository/files/_index.md#readme-and-index-files)
- プロジェクトのリポジトリ内のディレクトリのリスト

プロジェクトのコードを表示する権限を持たないユーザーの場合、概要ページには以下が表示されます。

- Wikiのホームページ
- プロジェクト内のイシューのリスト

### プロジェクトIDを使用してプロジェクトにアクセスする

{{< history >}}

- GitLab 16.7で、プロジェクトIDがアクションメニューに[移動](https://gitlab.com/gitlab-org/gitlab/-/issues/431539)しました。

{{< /history >}}

`https://gitlab.example.com/projects/<id>`で、名前の代わりにIDを使用してプロジェクトにアクセスできます。たとえば、パーソナルネームスペース`alex`にID `123456`のプロジェクト`my-project`がある場合、`https://gitlab.example.com/alex/my-project`または`https://gitlab.example.com/projects/123456`でプロジェクトにアクセスできます。

{{< alert type="note" >}}

GitLab 17.5以降では、このエンドポイントに`https://gitlab.example.com/-/p/<id>`を使用することもできます。

{{< /alert >}}

[GitLab API](../../api/_index.md)を使用してプロジェクトを操作する場合は、プロジェクトIDが必要になる場合もあります。

プロジェクトIDをコピーするには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを検索します。
1. プロジェクトの概要ページの右上隅で、**アクション**（{{< icon name="ellipsis_v" >}}）を選択します。
1. **プロジェクトIDをコピー**を選択します。

## インスタンスのすべてのプロジェクトを表示する

GitLabインスタンスのすべてのプロジェクトを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択します。
1. **探す**を選択します。

左側のサイドバーで、**プロジェクト**が選択されています。インスタンスのすべてのプロジェクトのリストが表示されます。

認証されていない場合、リストにはパブリックプロジェクトのみが表示されます。

## コントリビュート済みのプロジェクトを表示する

{{< history >}}

- GitLab 17.9で、`your_work_projects_vue`という名前の[フラグとともに](../../administration/feature_flags.md)[導入](https://gitlab.com/groups/gitlab-org/-/epics/13066)されました。デフォルトでは無効になっています。
- GitLab 17.10で、[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/465889)になりました。機能フラグ`your_work_projects_vue`が削除されました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

**コントリビュート済み**タブには、次のプロジェクトが表示されます。

- イシュー、マージリクエスト、またはエピックを作成したプロジェクト
- イシュー、マージリクエスト、またはエピックにコメントしたプロジェクト
- イシュー、マージリクエスト、またはエピックをクローズしたプロジェクト
- コミットをプッシュしたプロジェクト
- マージリクエストを承認したプロジェクト
- マージリクエストをマージしたプロジェクト

コントリビュート済みのプロジェクトを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択します。
1. **すべてのプロジェクトを表示**を選択します。
1. **コントリビュート済み**タブを選択します。

## メンバーになっているプロジェクトを表示する

{{< history >}}

- GitLab 17.9で、`your_work_projects_vue`という名前の[フラグとともに](../../administration/feature_flags.md)、タブのラベルが「あなたの」から「メンバー」に[変更](https://gitlab.com/groups/gitlab-org/-/epics/13066)されました。デフォルトでは無効になっています。
- GitLab 17.10で、タブのラベルの一般提供が[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/465889)されました。機能フラグ`your_work_projects_vue`が削除されました。

{{< /history >}}

メンバーになっているプロジェクトを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択します。
1. **すべてのプロジェクトを表示**を選択します。
1. **あなたの**タブを選択します。

{{< alert type="note" >}}

このタブは、`your_work_projects_vue`機能フラグが有効になっている場合は、**メンバー**として表示されます。

{{< /alert >}}

## パーソナルプロジェクトを表示する

パーソナルプロジェクトは、パーソナルネームスペースで作成されたプロジェクトです。

たとえば、ユーザー名`alex`でアカウントを作成し、自分のユーザー名で`my-project`というプロジェクトを作成すると、プロジェクトは`https://gitlab.example.com/alex/my-project`に作成されます。

パーソナルプロジェクトを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択します。
1. **すべてのプロジェクトを表示**を選択します。
1. **個人**タブを選択します。

または

1. 左側のサイドバーで、自分のアバターを選択し、次にユーザー名を選択します。
1. 左側のサイドバーで、**パーソナルプロジェクト**を選択します。

## Star付きのプロジェクトを表示する

[Star付きの](#star-a-project)プロジェクトを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択します。
1. **すべてのプロジェクトを表示**を選択します。
1. **お気に入り**タブを選択します。

または

1. 左側のサイドバーで、自分のアバターを選択し、次にユーザー名を選択します。
1. 左側のサイドバーで、**Star付きのプロジェクト**を選択します。

## プロジェクト名と説明を編集する

プロジェクトの一般設定を使用して、プロジェクトの詳細を編集します。

前提要件:

- プロジェクトのメンテナー以上のロールを持っている必要があります。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを検索します。
1. **設定>一般**を選択します。
1. **プロジェクト名**テキストボックスに、プロジェクト名を入力します。[プロジェクト名の制限](../reserved_names.md)を参照してください。
1. オプション: **プロジェクトの説明**テキストボックスに、プロジェクトの説明を入力します。説明は2,000文字に制限されています。CI/CDカタログに公開されているコンポーネントには、プロジェクトの説明が必要です。
1. **変更の保存**を選択します。

## プロジェクトアバターを追加する

プロジェクトを視覚的に識別できるように、プロジェクトアバターを追加します。アバターを追加しない場合、GitLabはプロジェクト名の最初の文字をデフォルトのプロジェクトアバターとして表示します。

プロジェクトアバターを追加するには、次のいずれかの方法を使用します。

- リポジトリに[ロゴを追加](#add-a-logo-to-your-repository)します。
- プロジェクトの設定で[アバターをアップロード](#upload-an-avatar-in-project-settings)します。

### リポジトリにロゴを追加する

プロジェクト設定にアバターをアップロードしていない場合、GitLabは`logo`という名前のファイルをリポジトリで検索し、デフォルトのプロジェクトアバターとして使用します。

前提要件:

- プロジェクトのメンテナー以上のロールを持っている必要があります。
- ファイルのサイズは200 KB以下である必要があります。理想的な画像サイズは192 x 192ピクセルです。
- ファイルの名前は`logo`で、拡張子は`.png`、`.jpg`、または`.gif`である必要があります。たとえば、`logo.gif`などです。

プロジェクトアバターとして使用するロゴファイルを追加するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを検索します。
1. プロジェクトリポジトリのルートで、ロゴファイルをアップロードします。

### プロジェクト設定でアバターをアップロードする

前提要件:

- プロジェクトのメンテナー以上のロールを持っている必要があります。
- ファイルのサイズは200 KB以下である必要があります。理想的な画像サイズは192 x 192ピクセルです。
- 画像は、次のいずれかのファイル形式である必要があります。
  - `.bmp`
  - `.gif`
  - `.ico`
  - `.jpeg`
  - `.png`
  - `.tiff`

プロジェクトの設定でアバターをアップロードするには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを検索します。
1. **設定>一般**を選択します。
1. **プロジェクトアバター**セクションで、**ファイルを選択**を選択します。
1. アバターファイルを選択します。
1. **変更の保存**を選択します。

## プロジェクトにスターを付ける

頻繁に使用するプロジェクトにスターを付けて、見つけやすくすることができます。

プロジェクトにスターを付けるには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを検索します。
1. ページの右上隅にある**スター**を選択します。

## プロジェクトを削除する

{{< history >}}

- GitLab 16.0で、PremiumプランとUltimateプランにおけるプロジェクトのデフォルトの削除動作が[プロジェクトの遅延削除](https://gitlab.com/gitlab-org/gitlab/-/issues/389557)に変更されました。
- GitLab 16.0の[GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/issues/393622)および[GitLab Self-Managed](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/119606)で、PremiumプランとUltimateプランにおけるデフォルトの削除動作が遅延削除に変更されました。

{{< /history >}}

プロジェクトを削除対象としてマークできます。プロジェクトを削除すると、次のようになります。

- パーソナルネームスペースのプロジェクトはすぐに削除されます。
- グループ内のプロジェクトは、保持期間後に削除されます。

前提要件:

- プロジェクトのオーナーロールを持っている必要があります。
- オーナーは[プロジェクトの削除を許可されている](../../administration/settings/visibility_and_access_controls.md#restrict-project-deletion-to-administrators)必要があります。

プロジェクトを削除するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを検索します。
1. **設定>一般**を選択します。
1. **高度な設定**を展開します。
1. **このプロジェクトを削除**セクションで、**プロジェクトを削除**を選択します。
1. 確認ダイアログで、プロジェクト名を入力し、**はい、プロジェクトを削除します**を選択します。

この操作により、プロジェクトと関連するすべてのリソース（イシューやマージリクエストなど）が削除されます。

[Railsコンソールを使用してプロジェクトを削除](troubleshooting.md#delete-a-project-using-console)することもできます。

### プロジェクトの遅延削除

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 15.1で、[パーソナルネームスペースのプロジェクトに対して有効になりました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89466)。
- GitLab 15.3で、[パーソナルネームスペースのプロジェクトに対して無効になりました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/95495)。
- GitLab 16.0の[GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/issues/393622)と[GitLab Self-Managed](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/119606)で、遅延削除がデフォルトで有効になり、即時削除のオプションが削除されました。

{{< /history >}}

前提要件:

- プロジェクトのオーナーロールを持っている必要があります。

グループ（パーソナルネームスペースではない）のプロジェクトは、遅延期間後に削除できます。

GitLab Self-Managedインスタンスでは、グループ管理者は1～90日間の削除遅延期間を定義できます。SaaSでは、調整できないデフォルトの保持期間は7日間です。

[削除保留中のプロジェクトを表示](#view-projects-pending-deletion)したり、Railsコンソールを使用して[削除保留中のプロジェクトを検索](troubleshooting.md#find-projects-that-are-pending-deletion)したりできます。

プロジェクトの削除をスケジュールしたユーザーが、削除が行われる前にプロジェクトへのアクセス権を失った場合（プロジェクを離脱したり、ロールがダウングレードされたり、プロジェクトからBANされたりした場合など）、削除ジョブは代わりにプロジェクトを復元してアーカイブ解除するため、プロジェクトは削除のスケジュールから外れます。

   {{< alert type="warning" >}}

   ジョブの実行前に、プロジェクトの削除をスケジュールしたユーザーがオーナーロールまたは管理者アクセス権を回復した場合、ジョブはプロジェクトを完全に削除します。

   {{< /alert >}}

### プロジェクトを直ちに削除する

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 16.0の[GitLab.com](https://gitlab.com/gitlab-org/gitlab/-/issues/393622)および[GitLab Self-Managed](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/119606)で、**管理者**エリアからグループ設定としてプロジェクトを直ちに削除するオプションは削除されました。

{{< /history >}}

削除の遅延を待たない場合は、プロジェクトを直ちに削除できます。これを行うには、[プロジェクトの削除](#delete-a-project)手順をもう一度実行します。

プロジェクトを削除する最初のサイクルでは、プロジェクトは遅延削除キューに移され、保持期間が経過すると自動的に削除されます。この遅延削除期間中に2回目の削除サイクルを実行すると、プロジェクトは直ちに削除されます。

前提要件:

- プロジェクトのオーナーロールを持っている必要があります。
- プロジェクトは[削除対象としてマーク](#delete-a-project)されている必要があります。

削除対象としてマークされたプロジェクトを直ちに削除するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを検索します。
1. **設定>一般**を選択します。
1. **高度な設定**を展開します。
1. **このプロジェクトを削除**セクションで、**プロジェクトを削除**を選択します。
1. 確認ダイアログで、プロジェクト名を入力し、**はい、プロジェクトを削除します**を選択します。

### 削除保留中のプロジェクトを表示する

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 17.9で、`your_work_projects_vue`という名前の[フラグとともに](../../administration/feature_flags.md)、タブのラベルが「削除の保留中」から「無効」に[変更](https://gitlab.com/groups/gitlab-org/-/epics/13066)されました。デフォルトでは無効になっています。
- GitLab 17.10で、タブのラベルの一般提供が[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/465889)されました。機能フラグ`your_work_projects_vue`が削除されました。

{{< /history >}}

削除保留中のすべてのプロジェクトのリストを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択します。
1. **すべてのプロジェクトを表示**を選択します。
1. **削除の保留中**タブを選択します。

{{< alert type="note" >}}

このタブは、`your_work_projects_vue`機能フラグが有効になっている場合は、**無効**として表示されます。

{{< /alert >}}

リスト内の各プロジェクトには、以下が表示されます。

- プロジェクトが削除対象としてマークされていることを示すバッジ
- プロジェクトが削除対象としてマークされた時刻
- プロジェクトが最終削除される予定の時刻
- 最終的なプロジェクトの削除を停止する**復元**アクション

## プロジェクトを復元する

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

前提要件:

- プロジェクトのオーナーロールを持っている必要があります。
- プロジェクトは削除対象としてマークされている必要があります。

削除対象としてマークされたプロジェクトを復元するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを検索します。
1. **設定>一般**を選択します。
1. **高度な設定**を展開します。
1. プロジェクトの復元セクションで、**プロジェクトを復元**を選択します。

## プロジェクトをアーカイブする

{{< history >}}

- GitLab 17.5で、Pagesの削除が[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/343109)されました。

{{< /history >}}

プロジェクトをアーカイブすると、一部の機能が読み取り専用になります。これらの機能は引き続きアクセスできますが、書き込みはできません。

- リポジトリ
- パッケージ
- イシュー
- マージリクエスト
- 機能フラグ
- プルミラーリング
- その他すべてのプロジェクト機能

アーカイブされたプロジェクトのアクティブなパイプラインスケジュールは、読み取り専用になりません。

プロジェクトにデプロイ済みのPagesがある場合、カスタムドメインとともに削除され、Pagesリンクにアクセスできなくなります。

アーカイブされたプロジェクトは次のようになります。

- プロジェクトページに`archived`バッジが表示されます。
- グループページ、**あなたの作業**ページ、**探す**ページの**無効**タブに表示されます。
- 読み取り専用になります。

前提要件:

- プロジェクトのアクティブなパイプラインスケジュールを[無効化](../../ci/pipelines/schedules.md#edit-a-pipeline-schedule)または削除していること。
<!-- LP: Remove this prerequisite after the issue is resolved (when a project is archived, active pipeline schedules continue to run). -->

プロジェクトをアーカイブするには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを検索します。
1. **設定>一般**を選択します。
1. **高度な設定**を展開します。
1. **プロジェクトをアーカイブ**セクションで、**プロジェクトをアーカイブ**を選択します。
1. 確認するには、**OK**をクリックします。

## プロジェクトをアーカイブ解除する

プロジェクトをアーカイブ解除すると、読み取り専用の制限が解除され、プロジェクトリストでプロジェクトを使用できるようになります。

前提要件:

- 管理者であるか、プロジェクトのオーナーロールを持っている必要があります。

1. アーカイブされたプロジェクトを検索します。
   1. 左側のサイドバーで、**検索または移動**を選択します。
   1. **すべてのプロジェクトを表示**を選択します。
   1. **プロジェクトを探す**を選択します。
   1. **プロジェクトの並べ替え**ドロップダウンリストで、**アーカイブしたプロジェクトを表示**を選択します。
   1. **名前で絞り込む**フィールドに、プロジェクト名を入力します。
   1. プロジェクトリンクを選択します。
1. 左側のサイドバーで、**設定>一般**を選択します。
1. **高度な設定**で、**展開**を選択します。
1. **プロジェクトのアーカイブ解除**セクションで、**プロジェクトのアーカイブ解除**を選択します。
1. 確認するには、**OK**をクリックします。

デプロイ済みのPagesは復元されないため、パイプラインを再実行する必要があります。

プロジェクトをアーカイブ解除すると、プルミラーリングプロセスが自動的に再開されます。

## プロジェクトアクティビティーを表示する

プロジェクトのアクティビティーを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを検索します。
1. **管理>アクティビティー**を選択します。
1. オプション: コントリビュートの種類でアクティビティーをフィルタリングするには、次のタブを選択します。

   - **すべて**: プロジェクトメンバーによるすべてのコントリビュート
   - **プッシュイベント**: プロジェクト内のプッシュイベント
   - **マージイベント**: プロジェクトで承認されたマージリクエスト
   - **イシューイベント**: プロジェクトでオープンおよびクローズされたイシュー
   - **コメント**: プロジェクトメンバーが投稿したコメント
   - **デザイン**: プロジェクトで追加、更新、削除されたデザイン
   - **チーム**: プロジェクトに参加および離脱したメンバー

### イベント期間の制限

GitLabは、パフォーマンス上の理由から、3年以上前のプロジェクトアクティビティーイベントをイベントテーブルから削除します。

## プロジェクト内を検索する

プロジェクト内を検索するには、左側のサイドバーで**検索または移動**を選択します。入力すると、GitLabによって絞り込まれます。

[お気に入り](#star-a-project)に登録したプロジェクト（**Star付きのプロジェクト**）を探すこともできます。

GitLab.comで利用可能なすべてのパブリックプロジェクトと内部プロジェクトを**探す**ことが可能で、表示レベルで絞り込んだり、**トレンド**、**最もお気に入りに登録**で最高評価を得ているもの、または**すべて**で検索できます。

プロジェクトは以下で並べ替えることができます:

- 名前
- 作成日
- 更新日
- お気に入り

### 言語でプロジェクトをフィルタリングする

{{< history >}}

- GitLab 15.9で、`project_language_search`という名前の[フラグとともに](../../administration/feature_flags.md)[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/385465)されました。デフォルトで有効になりました。
- GitLab 15.9で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/110956)になりました。機能フラグ`project_language_search`が削除されました。

{{< /history >}}

使用されているプログラミング言語でプロジェクトをフィルタリングできます。以下を実行します。

1. 左側のサイドバーで、**検索または移動**を選択します。
1. 次のいずれかを選択します。
   - **すべてのプロジェクトを表示**: プロジェクトをフィルタリングします。
   - **探す**: アクセスできるすべてのプロジェクトをフィルタリングします。
1. プロジェクトリストの上にある**検索または結果をフィルタリング**を選択します。
1. **言語**ドロップダウンリストで、プロジェクトのフィルタリングに使用する言語を選択します。

選択した言語を使用するプロジェクトのリストが表示されます。

### 自分が所有するプロジェクトのみを表示する

自分がオーナーであるプロジェクトのみを表示するには:

1. 左側のサイドバーで、**検索または移動**を選択します。
1. 次のいずれかを選択します。
   - **すべてのプロジェクトを表示**: プロジェクトをフィルタリングします。
   - **探す**: アクセスできるすべてのプロジェクトをフィルタリングします。
1. プロジェクトリストの上にある**検索または結果をフィルタリング**を選択します。
1. **ロール**ドロップダウンリストで、**オーナー**を選択します。

## リポジトリの名前を変更する

プロジェクトのリポジトリ名は、そのURLと、GitLabがインストールされているファイルディスク上の場所を定義します。

前提要件:

- 管理者であるか、プロジェクトのメンテナーまたはオーナーのロールを持っている必要があります。

{{< alert type="note" >}}

リポジトリパスを変更すると、ユーザーが古いURLにプッシュまたはプルした場合に問題が発生する可能性があります。リダイレクト期間とその副作用の詳細については、[リポジトリの名前変更時のリダイレクト](repository/_index.md#repository-path-changes)を参照してください。

{{< /alert >}}

リポジトリの名前を変更するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを検索します。
1. **設定>一般**を選択します。
1. **高度な設定**を展開します。
1. **パスを変更**テキストボックスで、パスを編集します。
1. **パスを変更**を選択します。

## プロジェクトを離脱する

{{< history >}}

- GitLab 16.7で、プロジェクトを離脱するためのボタンがアクションメニューに[移動](https://gitlab.com/gitlab-org/gitlab/-/issues/431539)しました。

{{< /history >}}

プロジェクトを離脱すると、次のようになります。

- プロジェクトメンバーではなくなり、コントリビュートできなくなります。
- 割り当てられていたすべてのイシューとマージリクエストの割り当てが解除されます。

前提要件:

- プロジェクトが[グループネームスペース](../namespace/_index.md)のグループの一部である場合にのみ、この方法でプロジェクトを離脱できます。
- プロジェクトの[直接メンバー](members/_index.md#membership-types)である必要があります。

プロジェクトを離脱するには:

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを検索します。
1. プロジェクトの概要ページの右上隅で、**アクション**（{{< icon name="ellipsis_v" >}}）を選択します。
1. **プロジェクトを離脱**を選択し、もう一度**プロジェクトを離脱**を選択します。

## プロジェクトにコンプライアンスフレームワークを追加する

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

[コンプライアンスフレームワーク](../compliance/compliance_frameworks.md)があるグループのプロジェクトにコンプライアンスフレームワークを追加できます。

## LDAPグループを介してプロジェクトへのアクセスを管理する

[LDAPを使用してグループメンバーシップを管理](../group/access_and_permissions.md#manage-group-memberships-with-ldap)できます。

LDAPグループを使用してプロジェクトへのアクセスを管理することはできませんが、次の回避策を使用できます。

前提要件:

- [LDAPをGitLabと統合](../../administration/auth/ldap/_index.md)する必要があります。
- 管理者である必要があります。

1. プロジェクトのメンバーシップを追跡するための[グループを作成](../group/_index.md#create-a-group)します。
1. そのグループの[LDAP同期を設定](../../administration/auth/ldap/ldap_synchronization.md)します。
1. LDAPグループを使用してプロジェクトへのアクセスを管理するには、[LDAP同期されたグループをメンバーとして追加](../group/manage.md)します。

## プロジェクトエイリアス

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

通常、GitLabリポジトリには、ネームスペースとプロジェクト名を使用してアクセスします。ただし、頻繁にアクセスされるリポジトリをGitLabに移行する場合は、プロジェクトエイリアスを使用して、元の名前でそれらのリポジトリにアクセスできます。プロジェクトエイリアスを介してリポジトリにアクセスすると、そのようなリポジトリの移行に関連するリスクが軽減されます。

この機能は、SSH経由のGitでのみ使用できます。また、プロジェクトエイリアスを作成できるのはGitLab管理者のみであり、APIを介してのみ作成できます。詳細については、[プロジェクトエイリアスAPIドキュメント](../../api/project_aliases.md)を参照してください。

管理者がプロジェクトのエイリアスを作成すると、そのエイリアスを使用してリポジトリのクローンを作成できます。たとえば、管理者がプロジェクト`https://gitlab.com/gitlab-org/gitlab`のエイリアス`gitlab`を作成した場合、`git clone git@gitlab.com:gitlab-org/gitlab.git`の代わりに`git clone git@gitlab.com:gitlab.git`を使用してプロジェクトのクローンを作成できます。

## 関連トピック

- [プロジェクトをインポートする](import/_index.md)
- [外部リポジトリをGitLab CI/CDに接続する](../../ci/ci_cd_for_external_repos/_index.md)
- [プロジェクトをフォークする](repository/forking_workflow.md#create-a-fork)
- [プロジェクトの表示レベル](../public_access.md#change-project-visibility)と[権限](settings/_index.md#configure-project-features-and-permissions)を調整する
- [プロジェクト名とグループ名のルール](../reserved_names.md#rules-for-usernames-project-and-group-names-and-slugs)
