---
stage: Create
group: Source Code
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Understand and configure the commit squashing options available in GitLab.
title: スカッシュとマージ
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

スカッシュとマージを行うと、複数の小さなコミットが1つの意味のあるコミットに結合されます。この方法は、リポジトリの履歴をcleanに保ち、変更の追跡や取り消しを容易にします。複数の機能を同時に行う場合、スカッシュは各機能の変更を明確な論理ユニットに分離します。

- 小さなコミットが結合され、[すべての変更箇所を取り消す](revert_changes.md)のが簡単になります。
- 単一のコミットがターゲットブランチにマージされると、完全なコミット履歴が保持されます。
- ベースブランチはcleanなままで、意味のあるコミットメッセージが含まれます。

## スカッシュとマージのワークフロー

ブランチがベースブランチにマージされるたびに、最大2つのコミットが追加されます。

- ブランチからコミットをスカッシュすることによって作成された単一のコミット。
- マージコミット。ただし、プロジェクトで[早送りマージ](methods/_index.md#fast-forward-merge)を有効にしている場合は除きます。早送りマージはマージコミットを無効にします。

デフォルトでは、スカッシュされたコミットには次のメタデータが含まれています。

- メッセージ: スカッシュコミットの説明、またはカスタマイズされたメッセージ
- 作成者: マージリクエストを作成したユーザー
- コミッター: スカッシュを開始したユーザー

プロジェクトオーナーは、すべてのスカッシュコミットおよびマージコミットの[新しいデフォルトメッセージを作成](commit_templates.md)できます。

## マージリクエストのデフォルトスカッシュオプションを設定する

マージリクエストを作成または編集する権限を持つユーザーは、マージリクエストのデフォルトのスカッシュオプションを設定できます。

前提要件:

- プロジェクトがスカッシュを許可または推奨するように[設定されている](#configure-squash-options-for-a-project)必要があります。

これを行うには、以下を実行します。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを見つけます。
1. **編集**を選択します。
1. **マージリクエストが承認されたときにコミットをスカッシュする**のチェックボックスをオンまたはオフにします。
1. **変更を保存**を選択します。

## マージリクエスト内でコミットをスカッシュする

プロジェクトでマージリクエストのスカッシュオプションを選択できる場合、マージプロセスの一部としてコミットをスカッシュするには、以下を実行します。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **コード > マージリクエスト**を選択し、マージリクエストを見つけます。
1. **マージ**ボタンのあるマージリクエストレポートセクションまでスクロールします。
1. **コミットをスカッシュ**のチェックボックスがオンになっていることを確認します。プロジェクトのスカッシュオプションが**許可しない**または**必須**のいずれかに設定されている場合、このチェックボックスは表示されません。
1. オプション。スカッシュコミットメッセージまたはマージコミットメッセージ（プロジェクトの設定によって異なります）を変更するには、**コミットメッセージを修正**を選択します。
1. マージリクエストをマージする準備ができたら、**マージ**を選択します。

## プロジェクトのスカッシュオプションを設定する

前提要件:

- このプロジェクトでのメンテナー以上のロールが必要です。

プロジェクト内のすべてのマージリクエストのデフォルトのスカッシュ動作を設定するには、以下を実行します。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **設定 > マージリクエスト**を選択します。
1. **マージ時にコミットをスカッシュする**セクションで、次の選択肢から動作を選択します。
   - **許可しない**: スカッシュは実行されず、オプションは表示されません。
   - **許可する**: スカッシュは許可されていますが、デフォルトではオフになっています。
   - **推奨**: スカッシュは許可され、デフォルトで選択されていますが、無効にすることができます。
   - **必須**: スカッシュは常に実行されます。マージリクエストにはスカッシュのオプションが表示されますが、ユーザーは変更できません。
1. **変更を保存**を選択します。

## 関連トピック

- [コミットメッセージテンプレート](commit_templates.md)
- [マージ方法](methods/_index.md)
